/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.project;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.project.ProjectImportData;
import org.jkiss.dbeaver.tools.project.ProjectImportWizardPageFile;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectImportWizard
extends Wizard
implements IImportWizard {
    private static final Log log = Log.getLog(ProjectImportWizard.class);
    private ProjectImportData data = new ProjectImportData();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(CoreMessages.dialog_project_import_wizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new ProjectImportWizardPageFile(this.data));
    }

    public boolean performFinish() {
        if (!DBWorkbench.getPlatform().getWorkspace().canManageProjects()) {
            DBWorkbench.getPlatformUI().showError("Import error", "You can't import projects");
            return false;
        }
        try {
            UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, (DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ProjectImportWizard.this.importProjects(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            DBWorkbench.getPlatformUI().showError("Import error", "Cannot import projects", ex.getTargetException());
            return false;
        }
        UIUtils.showMessageBox((Shell)this.getShell(), (String)CoreMessages.dialog_project_import_wizard_message_success_import_title, (String)CoreMessages.dialog_project_import_wizard_message_success_import_message, (int)2);
        return true;
    }

    private void importProjects(DBRProgressMonitor monitor) throws IOException, DBException {
        block19: {
            try (ZipFile zipFile = new ZipFile(this.data.getImportFile(), 1);){
                ZipEntry metaEntry = zipFile.getEntry("meta.xml");
                if (metaEntry == null) {
                    throw new DBException("Cannot find meta file");
                }
                HashMap<String, String> libMap = new HashMap<String, String>();
                HashMap<String, String> driverMap = new HashMap<String, String>();
                InputStream metaStream = zipFile.getInputStream(metaEntry);
                if (metaStream == null) {
                    throw new DBException("Cannot open meta file '" + metaEntry.getName() + "'");
                }
                try {
                    Element projectsElement;
                    Element driversElement;
                    Document metaDocument = XMLUtils.parseDocument((InputStream)metaStream);
                    Element libsElement = XMLUtils.getChildElement((Element)metaDocument.getDocumentElement(), (String)"libraries");
                    if (libsElement != null) {
                        List libList = XMLUtils.getChildElementList((Element)libsElement, (String)"file");
                        for (Element libElement : libList) {
                            libMap.put(libElement.getAttribute("path"), libElement.getAttribute("file"));
                            monitor.worked(1);
                        }
                    }
                    if ((driversElement = XMLUtils.getChildElement((Element)metaDocument.getDocumentElement(), (String)"drivers")) != null) {
                        List driverList = XMLUtils.getChildElementList((Element)driversElement, (String)"driver");
                        monitor.beginTask(CoreMessages.dialog_project_import_wizard_monitor_import_drivers, driverList.size());
                        for (Element driverElement : driverList) {
                            if (monitor.isCanceled()) break;
                            this.importDriver(monitor, driverElement, zipFile, libMap, driverMap);
                            monitor.worked(1);
                        }
                        DataSourceProviderRegistry.getInstance().saveDrivers();
                        monitor.done();
                    }
                    if ((projectsElement = XMLUtils.getChildElement((Element)metaDocument.getDocumentElement(), (String)"projects")) == null) break block19;
                    List projectList = XMLUtils.getChildElementList((Element)projectsElement, (String)"project");
                    for (Element projectElement : projectList) {
                        if (monitor.isCanceled()) {
                            break;
                        }
                        this.importProject(monitor, projectElement, zipFile, driverMap);
                    }
                }
                catch (XMLException e) {
                    throw new DBException("Cannot parse meta file", (Throwable)e);
                }
                catch (CoreException e) {
                    throw new DBException("Cannot persist project", (Throwable)e);
                }
                finally {
                    metaStream.close();
                }
            }
        }
    }

    private DriverDescriptor importDriver(DBRProgressMonitor monitor, Element driverElement, ZipFile zipFile, Map<String, String> libMap, Map<String, String> driverMap) throws IOException, DBException {
        String providerId = driverElement.getAttribute("provider");
        String driverId = driverElement.getAttribute("id");
        boolean isCustom = CommonUtils.getBoolean((String)driverElement.getAttribute("custom"));
        String driverCategory = driverElement.getAttribute("category");
        String driverName = driverElement.getAttribute("name");
        String driverClass = driverElement.getAttribute("class");
        String driverURL = driverElement.getAttribute("url");
        String driverDefaultPort = driverElement.getAttribute("port");
        String driverDescription = driverElement.getAttribute("description");
        DataSourceProviderDescriptor dataSourceProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
        if (dataSourceProvider == null) {
            throw new DBException("Cannot find data source provider '" + providerId + "' for driver '" + driverName + "'");
        }
        monitor.subTask(CoreMessages.dialog_project_import_wizard_monitor_load_driver + driverName);
        DriverDescriptor driver = null;
        if (!isCustom && (driver = dataSourceProvider.getDriver(driverId)) == null) {
            log.warn((Object)("Driver '" + driverId + "' not found in data source provider '" + dataSourceProvider.getName() + "'"));
        }
        if (driver == null) {
            Iterator<DriverDescriptor> matchedDrivers = new ArrayList();
            for (DriverDescriptor tmpDriver : dataSourceProvider.getEnabledDrivers()) {
                if (!CommonUtils.equalObjects((Object)tmpDriver.getDriverClassName(), (Object)driverClass)) continue;
                matchedDrivers.add(tmpDriver);
            }
            if (matchedDrivers.size() == 1) {
                driver = (DriverDescriptor)matchedDrivers.get(0);
            } else if (!matchedDrivers.isEmpty()) {
                Iterator iterator = matchedDrivers.iterator();
                while (iterator.hasNext()) {
                    DriverDescriptor tmpDriver;
                    tmpDriver = (DriverDescriptor)iterator.next();
                    if (!CommonUtils.equalObjects((Object)tmpDriver.getSampleURL(), (Object)driverURL) && !CommonUtils.equalObjects((Object)tmpDriver.getName(), (Object)driverName)) continue;
                    driver = tmpDriver;
                    break;
                }
                if (driver == null) {
                    log.warn((Object)("Ambiguous driver '" + driverName + "' - multiple drivers with class '" + driverClass + "' found. First one will be used"));
                    driver = (DriverDescriptor)matchedDrivers.get(0);
                }
            }
        }
        if (driver == null) {
            driver = dataSourceProvider.createDriver();
            driver.setName(driverName);
            driver.setCategory(driverCategory);
            driver.setDescription(driverDescription);
            driver.setDriverClassName(driverClass);
            if (!CommonUtils.isEmpty((String)driverDefaultPort)) {
                driver.setDriverDefaultPort(driverDefaultPort);
            }
            driver.setSampleURL(driverURL);
            driver.setModified(true);
            dataSourceProvider.addDriver(driver);
        }
        for (Element libElement : XMLUtils.getChildElementList((Element)driverElement, (String)"parameter")) {
            driver.setDriverParameter(libElement.getAttribute("name"), libElement.getAttribute("value"), false);
        }
        for (Element libElement : XMLUtils.getChildElementList((Element)driverElement, (String)"property")) {
            driver.setConnectionProperty(libElement.getAttribute("name"), libElement.getAttribute("value"));
        }
        if (CommonUtils.isEmpty((Collection)driver.getDriverLibraries())) {
            ArrayList<String> libraryList = new ArrayList<String>();
            for (Element libElement : XMLUtils.getChildElementList((Element)driverElement, (String)"file")) {
                libraryList.add(libElement.getAttribute("path"));
            }
            for (String libPath : libraryList) {
                Path importLibFile;
                ZipEntry libEntry;
                File libFile = new File(libPath);
                if (libFile.exists()) {
                    driver.addDriverLibrary(libPath, DBPDriverLibrary.FileType.jar);
                    continue;
                }
                String archiveLibEntry = libMap.get(libPath);
                if (archiveLibEntry == null || (libEntry = zipFile.getEntry(archiveLibEntry)) == null) continue;
                String libName = libFile.getName();
                Path contribFolder = DriverDescriptor.getDriversContribFolder();
                if (!Files.exists(contribFolder, new LinkOption[0])) {
                    try {
                        Files.createDirectories(contribFolder, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        log.error((Object)("Cannot create drivers folder '" + String.valueOf(contribFolder.toAbsolutePath()) + "'"), (Throwable)e);
                        continue;
                    }
                }
                if (!(importLibFile = contribFolder.resolve(libName)).normalize().startsWith(contribFolder.normalize())) {
                    throw new IOException("Zip entry is outside of the target directory");
                }
                if (!Files.exists(importLibFile, new LinkOption[0])) {
                    try (OutputStream os = Files.newOutputStream(importLibFile, new OpenOption[0]);
                         InputStream is = zipFile.getInputStream(libEntry);){
                        IOUtils.copyStream((InputStream)is, (OutputStream)os);
                    }
                }
                String contribPath = contribFolder.toAbsolutePath().toString();
                String libAbsolutePath = importLibFile.toAbsolutePath().toString();
                String relativePath = libAbsolutePath.substring(contribPath.length());
                while (relativePath.charAt(0) == '/' || relativePath.charAt(0) == '\\') {
                    relativePath = relativePath.substring(1);
                }
                driver.addDriverLibrary(relativePath, DBPDriverLibrary.FileType.jar);
            }
        }
        driverMap.put(driverId, driver.getId());
        return driver;
    }

    private IProject importProject(DBRProgressMonitor monitor, Element projectElement, ZipFile zipFile, Map<String, String> driverMap) throws DBException, CoreException, IOException {
        if (DBWorkbench.isDistributed()) {
            throw new DBException("Project import is not supported in distributed workspaces");
        }
        String projectName = projectElement.getAttribute("name");
        String projectDescription = projectElement.getAttribute("description");
        String targetProjectName = this.data.getTargetProjectName(projectName);
        if (targetProjectName == null) {
            return null;
        }
        IWorkspace eclipseWorkspace = DBPPlatformDesktop.getInstance().getWorkspace().getEclipseWorkspace();
        IProject project = eclipseWorkspace.getRoot().getProject(targetProjectName);
        if (project.exists()) {
            throw new DBException("Project '" + targetProjectName + "' already exists");
        }
        IProjectDescription description = eclipseWorkspace.newProjectDescription(project.getName());
        description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
        if (!CommonUtils.isEmpty((String)projectDescription)) {
            description.setComment(projectDescription);
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        project.create(description, 0, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
        try {
            monitor.beginTask(CoreMessages.dialog_project_import_wizard_monitor_import_projects, zipFile.size());
            monitor.subTask("Import project properties");
            project.open(RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
            monitor.worked(1);
            this.loadResourceProperties(monitor, (IResource)project, projectElement);
            monitor.worked(1);
            this.importChildResources(monitor, (IContainer)project, projectElement, "projects/" + projectName + "/", zipFile);
            this.updateDriverReferences(monitor, project, driverMap);
            monitor.done();
        }
        catch (Exception e) {
            try {
                project.delete(true, true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
            }
            catch (CoreException e1) {
                log.error((Object)e1);
            }
            throw new DBException("Error importing project resources", (Throwable)e);
        }
        return project;
    }

    private void importChildResources(DBRProgressMonitor monitor, IContainer resource, Element resourceElement, String containerPath, ZipFile zipFile) throws DBException, IOException, CoreException {
        for (Element childElement : XMLUtils.getChildElementList((Element)resourceElement, (String)"resource")) {
            IFolder childResource;
            String childName = childElement.getAttribute("name");
            monitor.subTask("Import " + childName);
            monitor.worked(1);
            String entryPath = containerPath + childName;
            ZipEntry resourceEntry = zipFile.getEntry(entryPath);
            if (resourceEntry == null) {
                log.error((Object)("Project resource '" + entryPath + "' not found in archive"));
                continue;
            }
            boolean isDirectory = resourceEntry.isDirectory();
            if (isDirectory) {
                IFolder folder;
                if (resource instanceof IFolder) {
                    folder = ((IFolder)resource).getFolder(childName);
                } else if (resource instanceof IProject) {
                    folder = ((IProject)resource).getFolder(childName);
                } else {
                    throw new DBException("Unsupported container type '" + resource.getClass().getName() + "'");
                }
                if (!folder.exists()) {
                    folder.create(true, true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                }
                childResource = folder;
                this.importChildResources(monitor, (IContainer)folder, childElement, entryPath + "/", zipFile);
            } else {
                IFile file;
                if (resource instanceof IFolder) {
                    file = ((IFolder)resource).getFile(childName);
                } else if (resource instanceof IProject) {
                    file = ((IProject)resource).getFile(childName);
                } else {
                    throw new DBException("Unsupported container type '" + resource.getClass().getName() + "'");
                }
                if (!file.exists()) {
                    file.create(zipFile.getInputStream(resourceEntry), true, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
                }
                childResource = file;
            }
            this.loadResourceProperties(monitor, (IResource)childResource, childElement);
        }
    }

    private void loadResourceProperties(DBRProgressMonitor monitor, IResource resource, Element element) throws CoreException, IOException {
        String charset;
        if (resource instanceof IFile && !CommonUtils.isEmpty((String)(charset = element.getAttribute("charset")))) {
            ((IFile)resource).setCharset(charset, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
        }
        for (Element attrElement : XMLUtils.getChildElementList((Element)element, (String)"attribute")) {
            String qualifier = attrElement.getAttribute("qualifier");
            String name = attrElement.getAttribute("name");
            String value = attrElement.getAttribute("value");
            if (CommonUtils.isEmpty((String)qualifier) || CommonUtils.isEmpty((String)name) || CommonUtils.isEmpty((String)value)) continue;
            resource.setPersistentProperty(new QualifiedName(qualifier, name), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDriverReferences(DBRProgressMonitor monitor, IProject project, Map<String, String> driverMap) throws DBException, CoreException, IOException {
        String filteredContent;
        IFile configFile = project.getFile(".dbeaver-data-sources.xml");
        if (configFile == null || !configFile.exists()) {
            configFile = project.getFile("data-sources.xml");
        }
        if (configFile == null || !configFile.exists()) {
            return;
        }
        InputStream configContents = configFile.getContents();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(configContents, GeneralUtils.DEFAULT_FILE_CHARSET));
            StringBuilder buffer = new StringBuilder();
            while ((line = in.readLine()) != null) {
                buffer.append(line).append(GeneralUtils.getDefaultLineSeparator());
            }
            filteredContent = buffer.toString();
            for (Map.Entry<String, String> entry : driverMap.entrySet()) {
                if (entry.getKey().equals(entry.getValue())) continue;
                filteredContent = filteredContent.replace("driver=\"" + entry.getKey() + "\"", "driver=\"" + entry.getValue() + "\"");
            }
        }
        finally {
            ContentUtils.close((Closeable)configContents);
        }
        configFile.setContents((InputStream)new ByteArrayInputStream(filteredContent.getBytes(GeneralUtils.DEFAULT_FILE_CHARSET)), true, false, RuntimeUtils.getNestedMonitor((DBRProgressMonitor)monitor));
    }
}

