/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class PostgreCreateDatabaseDialog
extends BaseDialog {
    private final PostgreDataSource dataSource;
    private List<PostgreRole> allUsers;
    private List<PostgreCharset> allEncodings;
    private List<PostgreCollation> allCollations;
    private List<PostgreTablespace> allTablespaces;
    private Set<String> allTemplates;
    private String name;
    private PostgreRole owner;
    private String dbTemplate;
    private PostgreCharset encoding;
    private PostgreTablespace tablespace;
    private Combo userCombo;
    private Combo encodingCombo;
    private Combo tablespaceCombo;
    private Combo templateCombo;

    public PostgreCreateDatabaseDialog(Shell parentShell, PostgreDataSource dataSource) {
        super(parentShell, PostgreMessages.dialog_create_db_title, null);
        this.dataSource = dataSource;
    }

    protected Composite createDialogArea(Composite parent) {
        final boolean supportsRoles = this.dataSource.isServerVersionAtLeast(8, 1);
        final boolean supportsEncodings = this.dataSource.getServerType().supportsEncodings();
        final boolean supportsTablespaces = this.dataSource.getServerType().supportsTablespaces();
        boolean supportsTemplates = this.dataSource.getServerType().supportsTemplates();
        Composite composite = super.createDialogArea(parent);
        Composite groupGeneral = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.dialog_create_db_group_general, (int)2, (int)768);
        Text nameText = UIUtils.createLabelText((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_db_name, (String)"");
        nameText.addModifyListener(e -> {
            this.name = nameText.getText().trim();
            this.getButton(0).setEnabled(!this.name.isEmpty());
        });
        if (supportsRoles) {
            this.userCombo = UIUtils.createLabelCombo((Composite)groupGeneral, (String)PostgreMessages.dialog_create_db_label_owner, (int)2060);
            this.userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.owner = PostgreCreateDatabaseDialog.this.allUsers.get(PostgreCreateDatabaseDialog.this.userCombo.getSelectionIndex());
                }
            });
        }
        Composite groupDefinition = UIUtils.createTitledComposite((Composite)composite, (String)PostgreMessages.dialog_create_db_group_definition, (int)2, (int)768);
        if (supportsTemplates) {
            this.templateCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_template_db, (int)2060);
            this.templateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.dbTemplate = PostgreCreateDatabaseDialog.this.templateCombo.getText();
                }
            });
        }
        if (supportsEncodings) {
            this.encodingCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_encoding, (int)2060);
            this.encodingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.encoding = PostgreCreateDatabaseDialog.this.allEncodings.get(PostgreCreateDatabaseDialog.this.encodingCombo.getSelectionIndex());
                }
            });
        }
        if (supportsTablespaces) {
            this.tablespaceCombo = UIUtils.createLabelCombo((Composite)groupDefinition, (String)PostgreMessages.dialog_create_db_label_tablesapce, (int)2060);
            this.tablespaceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PostgreCreateDatabaseDialog.this.tablespace = PostgreCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex() == 0 ? null : PostgreCreateDatabaseDialog.this.allTablespaces.get(PostgreCreateDatabaseDialog.this.tablespaceCombo.getSelectionIndex() - 1);
                }
            });
        }
        new AbstractJob(this, "Load users"){
            final /* synthetic */ PostgreCreateDatabaseDialog this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Create database", 1);
                try {
                    PostgreDatabase database = this.this$0.dataSource.getDefaultInstance();
                    this.this$0.allUsers = supportsRoles ? new ArrayList(database.getUsers(monitor)) : null;
                    this.this$0.allEncodings = supportsEncodings ? new ArrayList(database.getEncodings(monitor)) : null;
                    this.this$0.allTablespaces = supportsTablespaces ? new ArrayList(database.getTablespaces(monitor)) : null;
                    this.this$0.allTemplates = new TreeSet<String>(this.this$0.dataSource.getTemplateDatabases(monitor));
                    this.this$0.allTemplates.addAll(this.this$0.dataSource.getDatabases().stream().map(PostgreDatabase::getName).collect(Collectors.toList()));
                    PostgreRole dba = supportsRoles ? database.getDBA(monitor) : null;
                    String defUserName = dba == null ? "" : dba.getName();
                    PostgreCharset defCharset = supportsEncodings ? database.getDefaultEncoding(monitor) : null;
                    PostgreTablespace defTablespace = supportsTablespaces ? database.getDefaultTablespace(monitor) : null;
                    UIUtils.syncExec(() -> {
                        if (this.this$0.userCombo != null) {
                            for (PostgreRole authId : this.this$0.allUsers) {
                                String name = authId.getName();
                                this.this$0.userCombo.add(name);
                                if (!name.equals(defUserName)) continue;
                                this.this$0.owner = authId;
                            }
                            this.this$0.userCombo.setText(defUserName);
                        }
                        if (this.this$0.templateCombo != null) {
                            this.this$0.templateCombo.add("");
                            for (String tpl : this.this$0.allTemplates) {
                                this.this$0.templateCombo.add(tpl);
                            }
                        }
                        if (this.this$0.encodingCombo != null) {
                            for (PostgreCharset charset : this.this$0.allEncodings) {
                                this.this$0.encodingCombo.add(charset.getName());
                                if (charset != defCharset) continue;
                                this.this$0.encoding = defCharset;
                            }
                            if (defCharset != null) {
                                this.this$0.encodingCombo.setText(defCharset.getName());
                            }
                        }
                        if (this.this$0.tablespaceCombo != null) {
                            this.this$0.tablespaceCombo.add(PostgreMessages.dialog_create_db_tablespace_default);
                            for (PostgreTablespace ts : this.this$0.allTablespaces) {
                                this.this$0.tablespaceCombo.add(ts.getName());
                                if (ts != defTablespace) continue;
                                this.this$0.tablespace = ts;
                            }
                            this.this$0.tablespaceCombo.setText(defTablespace.getName());
                        }
                    });
                }
                catch (DBException e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    public String getTemplateName() {
        return this.dbTemplate;
    }

    public PostgreCharset getEncoding() {
        return this.encoding;
    }

    public PostgreTablespace getTablespace() {
        return this.tablespace;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

