/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.ui.internal;

import org.jkiss.dbeaver.ext.hana.ui.internal.HANAMessages;

public enum HANAEdition {
    GENERIC(HANAMessages.edition_generic),
    PLATFORM_SINGLE_DB(HANAMessages.edition_platform_single_db),
    PLATFORM_SYSTEM_DB(HANAMessages.edition_platform_system_db),
    PLATFORM_TENANT_DB(HANAMessages.edition_platform_tenant_db),
    EXPRESS(HANAMessages.edition_express),
    CLOUD(HANAMessages.edition_cloud);

    private final String title;

    private HANAEdition(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public static HANAEdition fromName(String name) {
        for (HANAEdition edition : HANAEdition.values()) {
            if (!edition.name().equals(name)) continue;
            return edition;
        }
        return GENERIC;
    }

    public static HANAEdition fromTitle(String title) {
        for (HANAEdition edition : HANAEdition.values()) {
            if (!edition.getTitle().equals(title)) continue;
            return edition;
        }
        return GENERIC;
    }
}

