/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSPathValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ShapeValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.Objects;
import org.w3c.dom.DOMException;

class PathValue
extends ShapeValue
implements CSSPathValue {
    private static final long serialVersionUID = 1L;
    private CSSTypedValue fillRule = null;
    private String path;

    PathValue() {
        super(CSSValue.Type.PATH);
    }

    protected PathValue(PathValue copied) {
        super(copied);
        if (copied.fillRule != null) {
            this.fillRule = copied.fillRule.clone();
        }
        this.path = copied.path;
    }

    public void setFillRule(CSSTypedValue fillRule) {
        if (fillRule == null) {
            throw new NullPointerException();
        }
        this.fillRule = fillRule;
    }

    @Override
    public CSSTypedValue getFillRule() {
        return this.fillRule;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.path;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    private DOMException createUnexpectedArgumentTypeException(LexicalUnit lu) {
        return new DOMException(17, "Unexpected argument in path(): " + lu.getCssText());
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        StringBuilder buf = new StringBuilder(32);
        buf.append("path(");
        if (this.fillRule != null) {
            buf.append(this.fillRule.getCssText()).append(',');
        }
        buf.append(ParseHelper.quote(this.path, '\''));
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"path(");
        if (this.fillRule != null) {
            this.fillRule.writeCssText(wri);
            wri.write(',');
            wri.write(' ');
        }
        wri.write((CharSequence)ParseHelper.quote(this.path, '\''));
        wri.write(')');
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fillRule, this.path);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathValue other = (PathValue)obj;
        return Objects.equals(this.fillRule, other.fillRule) && Objects.equals(this.path, other.path);
    }

    @Override
    public PathValue clone() {
        return new PathValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(PathValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            this.checkProxyValue(lu);
            switch (lu.getLexicalUnitType()) {
                case IDENT: {
                    ValueFactory factory = new ValueFactory();
                    CSSTypedValue fillRule = (CSSTypedValue)((Object)factory.createCSSPrimitiveValue(lu, true));
                    PathValue.this.setFillRule(fillRule);
                    lu = lu.getNextLexicalUnit();
                    if (lu == null || !this.checkProxyValue(lu) && lu.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        throw new DOMSyntaxException("Expected comma in path().");
                    }
                    lu = lu.getNextLexicalUnit();
                    this.checkProxyValue(lu);
                    if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.STRING) {
                        throw new DOMSyntaxException("No path in path().");
                    }
                }
                case STRING: {
                    PathValue.this.setPath(lu.getStringValue());
                    break;
                }
                default: {
                    throw PathValue.this.createUnexpectedArgumentTypeException(lu);
                }
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

