/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin.dynamic;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Subgraph;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.spi.DynamicStatistics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DynamicNbNodes
implements DynamicStatistics {
    public static final String NB_NODES = "dynamic nodecount";
    private GraphModel graphModel;
    private double window;
    private double tick;
    private Interval bounds;
    private Map<Double, Integer> counts;

    public void execute(GraphModel graphModel) {
        this.graphModel = graphModel;
        this.counts = new HashMap<Double, Integer>();
    }

    public String getReport() {
        XYSeries dSeries = ChartUtils.createXYSeries(this.counts, "Nb Nodes Time Series");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"# Nodes Time Series", (String)"Time", (String)"# Nodes", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, false);
        String imageFile = ChartUtils.renderChart(chart, "nb-nodes-ts.png");
        DecimalFormat f = new DecimalFormat("#0.000");
        String report = "<HTML> <BODY> <h1>Dynamic Number of Nodes Report </h1> <hr><br> Bounds: from " + f.format(this.bounds.getLow()) + " to " + f.format(this.bounds.getHigh()) + "<br> Window: " + this.window + "<br> Tick: " + this.tick + "<br><br><h2> Number of nodes over time: </h2><br /><br />" + imageFile;
        report = report + "<br /><br /></BODY></HTML>";
        return report;
    }

    public void loop(GraphView window, Interval interval) {
        Subgraph graph = this.graphModel.getGraph(window);
        int count = graph.getNodeCount();
        this.graphModel.getGraphVisible().setAttribute(NB_NODES, (Object)count, interval.getLow());
        this.graphModel.getGraphVisible().setAttribute(NB_NODES, (Object)count, interval.getHigh());
        this.counts.put(interval.getLow(), count);
        this.counts.put(interval.getHigh(), count);
    }

    public void end() {
    }

    public double getWindow() {
        return this.window;
    }

    public void setWindow(double window) {
        this.window = window;
    }

    public double getTick() {
        return this.tick;
    }

    public void setTick(double tick) {
        this.tick = tick;
    }

    public Interval getBounds() {
        return this.bounds;
    }

    public void setBounds(Interval bounds) {
        this.bounds = bounds;
    }
}

