# frozen_string_literal: true

require 'json'

module GitlabQuality
  module TestTooling
    module CodeCoverage
      class TestReport
        # @param [Hash<String, Object>] test_report The content of a test
        #   report (RSpec or Jest)
        def initialize(test_report)
          @test_report = test_report
        end

        # @return [Array<Hash<String, String>>] Content of the "examples"
        #   section of the test report
        def examples
          @examples ||= @test_report['examples']
        end

        # @return [Hash<String, Array<String>>] Test files mapped to all feature
        #   categories they belong to
        # @example Return value
        #   {
        #     "spec/path/to/file_spec.rb" => [
        #       "feature_category1", "feature_category2"
        #     ],
        #     ...
        #   }
        def tests_to_categories
          @tests_to_categories ||= examples.to_a.filter_map do |example|
            next unless example.is_a?(Hash)

            file_path = example['file_path']
            next unless file_path.is_a?(String)

            [file_path.gsub('./', ''), Array(example['feature_category']).compact]
          end.to_h
        end
      end
    end
  end
end
