# frozen_string_literal: true

module GitlabQuality
  module TestTooling
    module Report
      module GroupIssues
        class IssueCreator < IssueBase
          GROUPED_ISSUE_LABELS = Set.new(%w[test failure::test-environment automation:bot-authored type::maintenance]).freeze

          def initialize(client, options = {})
            super
            @formatter = IssueFormatter.new
          end

          def create_new_issue(grouped_failure)
            title = @formatter.generate_issue_title(grouped_failure)
            description = @formatter.generate_issue_description(grouped_failure, @options)
            labels = GROUPED_ISSUE_LABELS

            Runtime::Logger.info "Creating new grouped issue: #{title} (#{grouped_failure[:failures].size} failures)"

            create_issue(
              title: title,
              description: description,
              labels: labels,
              failures: grouped_failure[:failures]
            )
          end

          private

          def create_issue(title:, description:, labels:, failures:)
            Runtime::Logger.info "Creating issue: #{title} with #{failures.size} failures"

            handle_gitlab_api_error("creating issue") do
              issue = @client.create_issue(title: title, description: description, labels: labels.join(','))
              Runtime::Logger.info "Issue created successfully: #{issue.web_url}" if issue&.web_url
            end
          end
        end
      end
    end
  end
end
