/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class MetadataLogConfig {
    public static final String METADATA_LOG_DIR_CONFIG = "metadata.log.dir";
    public static final String METADATA_LOG_DIR_DOC = "This configuration determines where we put the metadata log. If it is not set, the metadata log is placed in the first log directory from log.dirs.";
    public static final String METADATA_SNAPSHOT_MAX_INTERVAL_MS_CONFIG = "metadata.log.max.snapshot.interval.ms";
    public static final long METADATA_SNAPSHOT_MAX_INTERVAL_MS_DEFAULT = TimeUnit.HOURS.toMillis(1L);
    public static final String METADATA_SNAPSHOT_MAX_NEW_RECORD_BYTES_CONFIG = "metadata.log.max.record.bytes.between.snapshots";
    public static final int METADATA_SNAPSHOT_MAX_NEW_RECORD_BYTES = 0x1400000;
    public static final String METADATA_SNAPSHOT_MAX_NEW_RECORD_BYTES_DOC = "This is the maximum number of bytes in the log between the latest snapshot and the high-watermark needed before generating a new snapshot. The default value is 20971520. To generate snapshots based on the time elapsed, see the <code>metadata.log.max.snapshot.interval.ms</code> configuration. The Kafka node will generate a snapshot when either the maximum time interval is reached or the maximum bytes limit is reached.";
    public static final String METADATA_SNAPSHOT_MAX_INTERVAL_MS_DOC = "This is the maximum number of milliseconds to wait to generate a snapshot if there are committed records in the log that are not included in the latest snapshot. A value of zero disables time based snapshot generation. The default value is " + METADATA_SNAPSHOT_MAX_INTERVAL_MS_DEFAULT + ". To generate snapshots based on the number of metadata bytes, see the <code>metadata.log.max.record.bytes.between.snapshots</code> configuration. The Kafka node will generate a snapshot when either the maximum time interval is reached or the maximum bytes limit is reached.";
    public static final String METADATA_LOG_SEGMENT_BYTES_CONFIG = "metadata.log.segment.bytes";
    public static final String METADATA_LOG_SEGMENT_BYTES_DOC = "The maximum size of a single metadata log file.";
    public static final int METADATA_LOG_SEGMENT_BYTES_DEFAULT = 0x40000000;
    public static final String INTERNAL_METADATA_LOG_SEGMENT_BYTES_CONFIG = "internal.metadata.log.segment.bytes";
    public static final String INTERNAL_METADATA_LOG_SEGMENT_BYTES_DOC = "The maximum size of a single metadata log file, only for testing.";
    public static final String METADATA_LOG_SEGMENT_MILLIS_CONFIG = "metadata.log.segment.ms";
    public static final String METADATA_LOG_SEGMENT_MILLIS_DOC = "The maximum time before a new metadata log file is rolled out (in milliseconds).";
    public static final long METADATA_LOG_SEGMENT_MILLIS_DEFAULT = 604800000L;
    public static final String METADATA_MAX_RETENTION_BYTES_CONFIG = "metadata.max.retention.bytes";
    public static final int METADATA_MAX_RETENTION_BYTES_DEFAULT = 0x6400000;
    public static final String METADATA_MAX_RETENTION_BYTES_DOC = "The maximum combined size of the metadata log and snapshots before deleting old snapshots and log files. Since at least one snapshot must exist before any logs can be deleted, this is a soft limit.";
    public static final String METADATA_MAX_RETENTION_MILLIS_CONFIG = "metadata.max.retention.ms";
    public static final String METADATA_MAX_RETENTION_MILLIS_DOC = "The number of milliseconds to keep a metadata log file or snapshot before deleting it. Since at least one snapshot must exist before any logs can be deleted, this is a soft limit.";
    public static final long METADATA_MAX_RETENTION_MILLIS_DEFAULT = 604800000L;
    public static final String METADATA_MAX_IDLE_INTERVAL_MS_CONFIG = "metadata.max.idle.interval.ms";
    public static final int METADATA_MAX_IDLE_INTERVAL_MS_DEFAULT = 500;
    public static final String METADATA_MAX_IDLE_INTERVAL_MS_DOC = "This configuration controls how often the active controller should write no-op records to the metadata partition. If the value is 0, no-op records are not appended to the metadata partition. The default value is 500";
    public static final String INTERNAL_METADATA_MAX_BATCH_SIZE_IN_BYTES_CONFIG = "internal.metadata.max.batch.size.in.bytes";
    public static final String INTERNAL_METADATA_MAX_BATCH_SIZE_IN_BYTES_DOC = "The largest record batch size allowed in the metadata log, only for testing.";
    public static final String INTERNAL_METADATA_MAX_FETCH_SIZE_IN_BYTES_CONFIG = "internal.metadata.max.fetch.size.in.bytes";
    public static final String INTERNAL_METADATA_MAX_FETCH_SIZE_IN_BYTES_DOC = "The maximum number of bytes to read when fetching from the metadata log, only for testing.";
    public static final String INTERNAL_METADATA_DELETE_DELAY_MILLIS_CONFIG = "internal.metadata.delete.delay.millis";
    public static final String INTERNAL_METADATA_DELETE_DELAY_MILLIS_DOC = "The amount of time to wait before deleting a file from the filesystem, only for testing.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("metadata.log.max.record.bytes.between.snapshots", ConfigDef.Type.LONG, (Object)0x1400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "This is the maximum number of bytes in the log between the latest snapshot and the high-watermark needed before generating a new snapshot. The default value is 20971520. To generate snapshots based on the time elapsed, see the <code>metadata.log.max.snapshot.interval.ms</code> configuration. The Kafka node will generate a snapshot when either the maximum time interval is reached or the maximum bytes limit is reached.").define("metadata.log.max.snapshot.interval.ms", ConfigDef.Type.LONG, (Object)METADATA_SNAPSHOT_MAX_INTERVAL_MS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, METADATA_SNAPSHOT_MAX_INTERVAL_MS_DOC).define("metadata.log.dir", ConfigDef.Type.STRING, null, null, ConfigDef.Importance.HIGH, "This configuration determines where we put the metadata log. If it is not set, the metadata log is placed in the first log directory from log.dirs.").define("metadata.log.segment.bytes", ConfigDef.Type.INT, (Object)0x40000000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0x800000), ConfigDef.Importance.HIGH, "The maximum size of a single metadata log file.").define("metadata.log.segment.ms", ConfigDef.Type.LONG, (Object)604800000L, null, ConfigDef.Importance.HIGH, "The maximum time before a new metadata log file is rolled out (in milliseconds).").define("metadata.max.retention.bytes", ConfigDef.Type.LONG, (Object)0x6400000, null, ConfigDef.Importance.HIGH, "The maximum combined size of the metadata log and snapshots before deleting old snapshots and log files. Since at least one snapshot must exist before any logs can be deleted, this is a soft limit.").define("metadata.max.retention.ms", ConfigDef.Type.LONG, (Object)604800000L, null, ConfigDef.Importance.HIGH, "The number of milliseconds to keep a metadata log file or snapshot before deleting it. Since at least one snapshot must exist before any logs can be deleted, this is a soft limit.").define("metadata.max.idle.interval.ms", ConfigDef.Type.INT, (Object)500, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "This configuration controls how often the active controller should write no-op records to the metadata partition. If the value is 0, no-op records are not appended to the metadata partition. The default value is 500").defineInternal("internal.metadata.log.segment.bytes", ConfigDef.Type.INT, null, null, ConfigDef.Importance.LOW, "The maximum size of a single metadata log file, only for testing.").defineInternal("internal.metadata.max.batch.size.in.bytes", ConfigDef.Type.INT, (Object)0x800000, null, ConfigDef.Importance.LOW, "The largest record batch size allowed in the metadata log, only for testing.").defineInternal("internal.metadata.max.fetch.size.in.bytes", ConfigDef.Type.INT, (Object)0x800000, null, ConfigDef.Importance.LOW, "The maximum number of bytes to read when fetching from the metadata log, only for testing.").defineInternal("internal.metadata.delete.delay.millis", ConfigDef.Type.LONG, (Object)60000L, null, ConfigDef.Importance.LOW, "The amount of time to wait before deleting a file from the filesystem, only for testing.");
    private final int logSegmentBytes;
    private final Integer internalSegmentBytes;
    private final long logSegmentMillis;
    private final long retentionMaxBytes;
    private final long retentionMillis;
    private final int internalMaxBatchSizeInBytes;
    private final int internalMaxFetchSizeInBytes;
    private final long internalDeleteDelayMillis;

    public MetadataLogConfig(AbstractConfig config) {
        this.logSegmentBytes = config.getInt(METADATA_LOG_SEGMENT_BYTES_CONFIG);
        this.internalSegmentBytes = config.getInt(INTERNAL_METADATA_LOG_SEGMENT_BYTES_CONFIG);
        this.logSegmentMillis = config.getLong(METADATA_LOG_SEGMENT_MILLIS_CONFIG);
        this.retentionMaxBytes = config.getLong(METADATA_MAX_RETENTION_BYTES_CONFIG);
        this.retentionMillis = config.getLong(METADATA_MAX_RETENTION_MILLIS_CONFIG);
        this.internalMaxBatchSizeInBytes = config.getInt(INTERNAL_METADATA_MAX_BATCH_SIZE_IN_BYTES_CONFIG);
        this.internalMaxFetchSizeInBytes = config.getInt(INTERNAL_METADATA_MAX_FETCH_SIZE_IN_BYTES_CONFIG);
        this.internalDeleteDelayMillis = config.getLong(INTERNAL_METADATA_DELETE_DELAY_MILLIS_CONFIG);
    }

    public int logSegmentBytes() {
        return this.logSegmentBytes;
    }

    public Integer internalSegmentBytes() {
        return this.internalSegmentBytes;
    }

    public long logSegmentMillis() {
        return this.logSegmentMillis;
    }

    public long retentionMaxBytes() {
        return this.retentionMaxBytes;
    }

    public long retentionMillis() {
        return this.retentionMillis;
    }

    public int internalMaxBatchSizeInBytes() {
        return this.internalMaxBatchSizeInBytes;
    }

    public int internalMaxFetchSizeInBytes() {
        return this.internalMaxFetchSizeInBytes;
    }

    public long internalDeleteDelayMillis() {
        return this.internalDeleteDelayMillis;
    }
}

