/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa;

import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.jpa.CachingType;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.tool.schema.Action;

public class HibernatePersistenceConfiguration
extends PersistenceConfiguration {
    private final URL rootUrl;
    private final List<URL> jarFileUrls = new ArrayList<URL>();

    public HibernatePersistenceConfiguration(String name) {
        super(name);
        this.rootUrl = null;
    }

    public HibernatePersistenceConfiguration(String name, URL rootURL) {
        super(name);
        this.rootUrl = rootURL;
    }

    public HibernatePersistenceConfiguration(String name, Class<?> classFromRootUrl) {
        this(name, classFromRootUrl.getProtectionDomain().getCodeSource().getLocation());
    }

    public SessionFactory createEntityManagerFactory() {
        return (SessionFactory)super.createEntityManagerFactory();
    }

    public HibernatePersistenceConfiguration jdbcDriver(String driverName) {
        this.property("jakarta.persistence.jdbc.driver", driverName);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcUrl(String url) {
        this.property("jakarta.persistence.jdbc.url", url);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcUsername(String username) {
        this.property("jakarta.persistence.jdbc.user", username);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcPassword(String password) {
        this.property("jakarta.persistence.jdbc.password", password);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcCredentials(String username, String password) {
        this.jdbcUsername(username);
        this.jdbcPassword(password);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcPoolSize(int poolSize) {
        this.property("hibernate.connection.pool_size", poolSize);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcAutocommit(boolean autocommit) {
        this.property("hibernate.connection.autocommit", autocommit);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcTransactionIsolation(int isolationLevel) {
        this.property("hibernate.connection.isolation", isolationLevel);
        return this;
    }

    public HibernatePersistenceConfiguration showSql(boolean showSql, boolean formatSql, boolean highlightSql) {
        this.property("hibernate.show_sql", showSql);
        this.property("hibernate.format_sql", formatSql);
        this.property("hibernate.highlight_sql", highlightSql);
        return this;
    }

    public HibernatePersistenceConfiguration queryCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.query", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration transactionCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.transaction", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration closedCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.closed", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration proxyCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.proxy", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration cachingCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.proxy", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration globalGeneratorCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.global_id_generators", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration orderByMappingCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.orderby", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration loadByIdCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.load_by_id", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration caching(CachingType type) {
        assert (Objects.nonNull((Object)type));
        if (type == CachingType.NONE || type == CachingType.AUTO) {
            this.property("hibernate.cache.use_second_level_cache", false);
            this.property("hibernate.cache.use_query_cache", false);
        } else if (type == CachingType.BOTH) {
            this.property("hibernate.cache.use_second_level_cache", true);
            this.property("hibernate.cache.use_query_cache", true);
        } else if (type == CachingType.DATA) {
            this.property("hibernate.cache.use_second_level_cache", true);
            this.property("hibernate.cache.use_query_cache", false);
        } else if (type == CachingType.QUERY) {
            this.property("hibernate.cache.use_second_level_cache", false);
            this.property("hibernate.cache.use_query_cache", true);
        }
        return this;
    }

    public HibernatePersistenceConfiguration cachingAccessType(AccessType type) {
        this.property("hibernate.cache.default_cache_concurrency_strategy", (Object)type);
        return this;
    }

    public HibernatePersistenceConfiguration statementInspector(Class<? extends StatementInspector> inspectorImpl) {
        this.property("hibernate.session_factory.statement_inspector", inspectorImpl);
        return this;
    }

    public HibernatePersistenceConfiguration statementInspector(StatementInspector inspector) {
        this.property("hibernate.session_factory.statement_inspector", inspector);
        return this;
    }

    public HibernatePersistenceConfiguration defaultCatalog(String catalogName) {
        this.property("hibernate.default_catalog", catalogName);
        return this;
    }

    public HibernatePersistenceConfiguration defaultSchema(String schemaName) {
        this.property("hibernate.default_schema", schemaName);
        return this;
    }

    public HibernatePersistenceConfiguration nationalizedCharacterData(boolean enabled) {
        this.property("hibernate.use_nationalized_character_data", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration xmlMappings(boolean enabled) {
        this.property("hibernate.xml_mapping_enabled", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration xmlValidation(boolean enabled) {
        this.property("hibernate.validate_xml", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration collectStatistics(boolean enabled) {
        this.property("hibernate.generate_statistics", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration managedClasses(Class<?> ... managedClasses) {
        Collections.addAll(this.managedClasses(), managedClasses);
        return this;
    }

    public HibernatePersistenceConfiguration managedClasses(Collection<Class<?>> managedClasses) {
        this.managedClasses().addAll(managedClasses);
        return this;
    }

    public HibernatePersistenceConfiguration mappingFiles(String ... names) {
        Collections.addAll(this.mappingFiles(), names);
        return this;
    }

    public HibernatePersistenceConfiguration mappingFiles(Collection<String> names) {
        this.mappingFiles().addAll(names);
        return this;
    }

    public HibernatePersistenceConfiguration jarFileUrl(URL url) {
        this.jarFileUrls.add(url);
        return this;
    }

    public HibernatePersistenceConfiguration jarFileUrls(URL ... urls) {
        Collections.addAll(this.jarFileUrls, urls);
        return this;
    }

    public HibernatePersistenceConfiguration jarFileUrls(Collection<URL> urls) {
        this.jarFileUrls.addAll(urls);
        return this;
    }

    public HibernatePersistenceConfiguration schemaToolingAction(Action action) {
        this.property("hibernate.hbm2ddl.auto", (Object)action);
        return this;
    }

    public HibernatePersistenceConfiguration provider(String providerClassName) {
        return (HibernatePersistenceConfiguration)super.provider(providerClassName);
    }

    public HibernatePersistenceConfiguration jtaDataSource(String dataSourceJndiName) {
        return (HibernatePersistenceConfiguration)super.jtaDataSource(dataSourceJndiName);
    }

    public HibernatePersistenceConfiguration nonJtaDataSource(String dataSourceJndiName) {
        return (HibernatePersistenceConfiguration)super.nonJtaDataSource(dataSourceJndiName);
    }

    public HibernatePersistenceConfiguration managedClass(Class<?> managedClass) {
        return (HibernatePersistenceConfiguration)super.managedClass(managedClass);
    }

    public HibernatePersistenceConfiguration mappingFile(String name) {
        return (HibernatePersistenceConfiguration)super.mappingFile(name);
    }

    public HibernatePersistenceConfiguration transactionType(PersistenceUnitTransactionType transactionType) {
        return (HibernatePersistenceConfiguration)super.transactionType(transactionType);
    }

    public HibernatePersistenceConfiguration sharedCacheMode(SharedCacheMode sharedCacheMode) {
        return (HibernatePersistenceConfiguration)super.sharedCacheMode(sharedCacheMode);
    }

    public HibernatePersistenceConfiguration validationMode(ValidationMode validationMode) {
        return (HibernatePersistenceConfiguration)super.validationMode(validationMode);
    }

    public HibernatePersistenceConfiguration property(String name, Object value) {
        return (HibernatePersistenceConfiguration)super.property(name, value);
    }

    public HibernatePersistenceConfiguration properties(Map<String, ?> properties) {
        return (HibernatePersistenceConfiguration)super.properties(properties);
    }

    public List<URL> jarFileUrls() {
        return this.jarFileUrls;
    }

    public URL rootUrl() {
        return this.rootUrl;
    }
}

