/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.DatastoreProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageSyncTask;
import org.keycloak.storage.datastore.DefaultDatastoreProvider;
import org.keycloak.storage.user.SynchronizationResult;

public class UserStoragePrivateUtil {
    public static UserProvider userLocalStorage(KeycloakSession session) {
        return ((DefaultDatastoreProvider)session.getProvider(DatastoreProvider.class)).userLocalStorage();
    }

    public static SynchronizationResult runFullSync(KeycloakSessionFactory sessionFactory, UserStorageProviderModel provider) {
        return (SynchronizationResult)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)sessionFactory, session -> {
            RealmModel realm = session.realms().getRealm(provider.getParentId());
            session.getContext().setRealm(realm);
            return new UserStorageSyncTask(provider, UserStorageProviderModel.SyncMode.FULL).runWithResult(session);
        });
    }

    public static SynchronizationResult runPeriodicSync(KeycloakSessionFactory sessionFactory, UserStorageProviderModel provider) {
        return (SynchronizationResult)KeycloakModelUtils.runJobInTransactionWithResult((KeycloakSessionFactory)sessionFactory, session -> {
            RealmModel realm = session.realms().getRealm(provider.getParentId());
            session.getContext().setRealm(realm);
            return new UserStorageSyncTask(provider, UserStorageProviderModel.SyncMode.CHANGED).runWithResult(session);
        });
    }
}

