/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg;

import com.hankcs.hanlp.algorithm.Viterbi;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.CoreDictionaryTransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.CustomDictionary;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.seg.common.Vertex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CharacterBasedSegment
extends Segment {
    public static CoreDictionary.Attribute guessAttribute(Term term) {
        CoreDictionary.Attribute attribute = CoreDictionary.get(term.word);
        if (attribute == null) {
            attribute = CustomDictionary.get(term.word);
        }
        if (attribute == null) {
            if (term.nature != null) {
                if (Nature.nx == term.nature) {
                    attribute = new CoreDictionary.Attribute(Nature.nx);
                } else if (Nature.m == term.nature) {
                    attribute = CoreDictionary.get(CoreDictionary.M_WORD_ID);
                }
            } else {
                attribute = term.word.trim().length() == 0 ? new CoreDictionary.Attribute(Nature.x) : new CoreDictionary.Attribute(Nature.nz);
            }
        } else {
            term.nature = attribute.nature[0];
        }
        return attribute;
    }

    @Override
    protected List<Term> segSentence(char[] sentence) {
        if (sentence.length == 0) {
            return Collections.emptyList();
        }
        List<Term> termList = this.roughSegSentence(sentence);
        if (!(this.config.ner || this.config.useCustomDictionary || this.config.speechTagging)) {
            return termList;
        }
        List<Vertex> vertexList = this.toVertexList(termList, true);
        if (this.config.speechTagging) {
            Viterbi.compute(vertexList, CoreDictionaryTransformMatrixDictionary.transformMatrixDictionary);
            int i = 0;
            for (Term term : termList) {
                if (term.nature != null) {
                    term.nature = vertexList.get(i + 1).guessNature();
                }
                ++i;
            }
        }
        if (this.config.useCustomDictionary) {
            this.combineByCustomDictionary(vertexList);
            termList = CharacterBasedSegment.convert(vertexList, this.config.offset);
        }
        return termList;
    }

    protected abstract List<Term> roughSegSentence(char[] var1);

    protected List<Vertex> toVertexList(List<Term> wordList, boolean appendStart) {
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>(wordList.size() + 2);
        if (appendStart) {
            vertexList.add(Vertex.newB());
        }
        for (Term word : wordList) {
            CoreDictionary.Attribute attribute = CharacterBasedSegment.guessAttribute(word);
            Vertex vertex = new Vertex(word.word, attribute);
            vertexList.add(vertex);
        }
        if (appendStart) {
            vertexList.add(Vertex.newE());
        }
        return vertexList;
    }
}

