/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.global;

import net.adaptivebox.global.RandomGenerator;

public class BasicBound {
    public static final double MINDOUBLE = -1.0E308;
    public static final double MAXDOUBLE = 1.0E308;
    public double minValue = -1.0E308;
    public double maxValue = 1.0E308;

    public BasicBound() {
    }

    public BasicBound(double d, double d2) {
        this.minValue = Math.min(d, d2);
        this.maxValue = Math.max(d, d2);
    }

    public double getLength() {
        return Math.abs(this.maxValue - this.minValue);
    }

    public double boundAdjust(double d) {
        if (d > this.maxValue) {
            d = this.maxValue;
        } else if (d < this.minValue) {
            d = this.minValue;
        }
        return d;
    }

    public double annulusAdjust(double d) {
        if (d > this.maxValue) {
            double d2 = (d - this.maxValue) % this.getLength();
            d = this.minValue + d2;
        } else if (d < this.minValue) {
            double d3 = (this.minValue - d) % this.getLength();
            d = this.maxValue - d3;
        }
        return d;
    }

    public double getRandomValue() {
        return RandomGenerator.doubleRangeRandom(this.minValue, this.maxValue);
    }
}

