/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

public final class Validate {
    private Validate() {
    }

    public static void isTrue(boolean expression) {
        Validate.isTrue(expression, "");
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> T notNull(T object) {
        return Validate.notNull(object, "");
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
        return object;
    }

    public static <T extends Comparable<T>> T checkRange(T value, T begin, T end) {
        if (value.compareTo(begin) >= 0 && value.compareTo(end) <= 0) {
            return value;
        }
        throw new IllegalArgumentException("Value [" + value + "] out of range: [" + begin + ".." + end + "]");
    }
}

