/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.sort;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.fielddata.AbstractBinaryDocValues;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.opensearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.script.NumberSortScript;
import org.opensearch.script.Script;
import org.opensearch.script.StringSortScript;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.MultiValueMode;
import org.opensearch.search.sort.BucketedSort;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.NestedSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortFieldAndFormat;
import org.opensearch.search.sort.SortMode;
import org.opensearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder<ScriptSortBuilder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ScriptSortBuilder.class);
    public static final String NAME = "_script";
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField SORTMODE_FIELD = new ParseField("mode", new String[0]);
    private final Script script;
    private final ScriptSortType type;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private NestedSortBuilder nestedSort;
    private static final ConstructingObjectParser<ScriptSortBuilder, Void> PARSER = new ConstructingObjectParser("_script", a -> new ScriptSortBuilder((Script)a[0], (ScriptSortType)((Object)((Object)a[1]))));

    public ScriptSortBuilder(Script script, ScriptSortType type) {
        Objects.requireNonNull(script, "script cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.script = script;
        this.type = type;
    }

    ScriptSortBuilder(ScriptSortBuilder original) {
        this.script = original.script;
        this.type = original.type;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.nestedFilter = original.nestedFilter;
        this.nestedPath = original.nestedPath;
        this.nestedSort = original.nestedSort;
    }

    public ScriptSortBuilder(StreamInput in) throws IOException {
        this.script = new Script(in);
        this.type = ScriptSortType.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = (SortMode)in.readOptionalWriteable(SortMode::readFromStream);
        this.nestedPath = in.readOptionalString();
        this.nestedFilter = (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nestedSort = (NestedSortBuilder)in.readOptionalWriteable(NestedSortBuilder::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.type.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.sortMode);
        out.writeOptionalString(this.nestedPath);
        out.writeOptionalNamedWriteable((NamedWriteable)this.nestedFilter);
        out.writeOptionalWriteable((Writeable)this.nestedSort);
    }

    public Script script() {
        return this.script;
    }

    public ScriptSortType type() {
        return this.type;
    }

    public ScriptSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null.");
        if (ScriptSortType.STRING.equals((Object)this.type) && (sortMode == SortMode.SUM || sortMode == SortMode.AVG || sortMode == SortMode.MEDIAN)) {
            throw new IllegalArgumentException("script sort of type [string] doesn't support mode [" + String.valueOf((Object)sortMode) + "]");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    @Deprecated
    public ScriptSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedFilter = nestedFilter;
        return this;
    }

    @Deprecated
    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    @Deprecated
    public ScriptSortBuilder setNestedPath(String nestedPath) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedPath = nestedPath;
        return this;
    }

    @Deprecated
    public String getNestedPath() {
        return this.nestedPath;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public ScriptSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        if (this.nestedFilter != null || this.nestedPath != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedSort = nestedSort;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(SCRIPT_FIELD.getPreferredName(), (ToXContent)this.script);
        builder.field(TYPE_FIELD.getPreferredName(), (Object)this.type);
        builder.field(ORDER_FIELD.getPreferredName(), (Object)this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), (Object)this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), (ToXContent)this.nestedFilter, builderParams);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), (ToXContent)this.nestedSort);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScriptSortBuilder fromXContent(XContentParser parser, String elementName) {
        return (ScriptSortBuilder)PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(QueryShardContext context) throws IOException {
        return new SortFieldAndFormat(new SortField(NAME, (FieldComparatorSource)this.fieldComparatorSource(context), this.order == SortOrder.DESC), DocValueFormat.RAW);
    }

    @Override
    public BucketedSort buildBucketedSort(QueryShardContext context, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        return this.fieldComparatorSource(context).newBucketedSort(context.bigArrays(), this.order, DocValueFormat.RAW, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource fieldComparatorSource(QueryShardContext context) throws IOException {
        IndexFieldData.XFieldComparatorSource.Nested nested;
        MultiValueMode valueMode = null;
        if (this.sortMode != null) {
            valueMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        if (valueMode == null) {
            MultiValueMode multiValueMode = valueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (this.nestedSort != null) {
            FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
            nested = ScriptSortBuilder.resolveNested(context, this.nestedSort);
        } else {
            nested = ScriptSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        }
        switch (this.type.ordinal()) {
            case 0: {
                StringSortScript.Factory factory = context.compile(this.script, StringSortScript.CONTEXT);
                final StringSortScript.LeafFactory searchScript = factory.newFactory(this.script.getParams(), context.lookup());
                return new BytesRefFieldComparatorSource(null, null, valueMode, nested){
                    final Map<LeafReaderContext, StringSortScript> leafContextSortScriptMap;
                    {
                        super(indexFieldData, missingValue, sortMode, nested);
                        this.leafContextSortScriptMap = new ConcurrentHashMap<LeafReaderContext, StringSortScript>();
                    }

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        final StringSortScript leafScript = this.leafContextSortScriptMap.computeIfAbsent(context, ctx -> {
                            try {
                                return searchScript.newInstance((LeafReaderContext)ctx);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                        AbstractBinaryDocValues values = new AbstractBinaryDocValues(this){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            public boolean advanceExact(int doc) throws IOException {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            public BytesRef binaryValue() {
                                this.spare.copyChars((CharSequence)leafScript.execute());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(Scorable scorer, LeafReaderContext context) {
                        this.leafContextSortScriptMap.get(context).setScorer(scorer);
                    }

                    @Override
                    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                        throw new IllegalArgumentException("error building sort for [_script]: script sorting only supported on [numeric] scripts but was [" + String.valueOf((Object)ScriptSortBuilder.this.type) + "]");
                    }
                };
            }
            case 1: {
                NumberSortScript.Factory numberSortFactory = context.compile(this.script, NumberSortScript.CONTEXT);
                final NumberSortScript.LeafFactory numberSortScript = numberSortFactory.newFactory(this.script.getParams(), context.lookup());
                return new DoubleValuesComparatorSource(this, null, Double.MAX_VALUE, valueMode, nested){
                    final Map<LeafReaderContext, NumberSortScript> leafContextSortScriptMap;
                    {
                        super(indexFieldData, missingValue, sortMode, nested);
                        this.leafContextSortScriptMap = new ConcurrentHashMap<LeafReaderContext, NumberSortScript>();
                    }

                    @Override
                    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
                        final NumberSortScript leafScript = this.leafContextSortScriptMap.computeIfAbsent(context, ctx -> {
                            try {
                                return numberSortScript.newInstance((LeafReaderContext)ctx);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                        NumericDoubleValues values = new NumericDoubleValues(this){

                            public boolean advanceExact(int doc) throws IOException {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            public double doubleValue() {
                                return leafScript.execute();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(Scorable scorer, LeafReaderContext context) {
                        this.leafContextSortScriptMap.get(context).setScorer(scorer);
                    }
                };
            }
        }
        throw new QueryShardException(context, "custom script sort type [" + String.valueOf((Object)this.type) + "] not supported", new Object[0]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScriptSortBuilder other = (ScriptSortBuilder)object;
        return Objects.equals(this.script, other.script) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.order, (Object)other.order) && Objects.equals((Object)this.sortMode, (Object)other.sortMode) && Objects.equals(this.nestedFilter, other.nestedFilter) && Objects.equals(this.nestedPath, other.nestedPath) && Objects.equals(this.nestedSort, other.nestedSort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.script, this.type, this.order, this.sortMode, this.nestedFilter, this.nestedPath, this.nestedSort});
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public ScriptSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedFilter == null && this.nestedSort == null) {
            return this;
        }
        if (this.nestedFilter != null) {
            QueryBuilder rewrite = this.nestedFilter.rewrite(ctx);
            if (this.nestedFilter == rewrite) {
                return this;
            }
            return new ScriptSortBuilder(this).setNestedFilter(rewrite);
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new ScriptSortBuilder(this).setNestedSort(rewrite);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> ScriptSortType.fromString(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORTMODE_FIELD);
        PARSER.declareString((fieldSortBuilder, nestedPath) -> {
            deprecationLogger.deprecate("script_nested_path", "[nested_path] has been deprecated in favor of the [nested] parameter", new Object[0]);
            fieldSortBuilder.setNestedPath((String)nestedPath);
        }, NESTED_PATH_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedFilter, (p, c) -> {
            deprecationLogger.deprecate("script_nested_filter", "[nested_filter] has been deprecated in favour for the [nested] parameter", new Object[0]);
            return SortBuilder.parseNestedFilter(p);
        }, NESTED_FILTER_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
    }

    public static enum ScriptSortType implements Writeable
    {
        STRING,
        NUMBER;


        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        static ScriptSortType readFromStream(StreamInput in) throws IOException {
            return (ScriptSortType)in.readEnum(ScriptSortType.class);
        }

        public static ScriptSortType fromString(String str) {
            Objects.requireNonNull(str, "input string is null");
            switch (str.toLowerCase(Locale.ROOT)) {
                case "string": {
                    return STRING;
                }
                case "number": {
                    return NUMBER;
                }
            }
            throw new IllegalArgumentException("Unknown ScriptSortType [" + str + "]");
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

