/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.settings;

import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.settings.LegacyOpenDistroDestinationSettings;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.settings.SecureString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/opensearch/alerting/settings/DestinationSettings;", "", "<init>", "()V", "Companion", "opensearch-alerting"})
public final class DestinationSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DESTINATION_SETTING_PREFIX = "plugins.alerting.destination.";
    @NotNull
    public static final String EMAIL_DESTINATION_SETTING_PREFIX = "plugins.alerting.destination.email.";
    @NotNull
    private static final List<String> ALLOW_LIST_NONE = CollectionsKt.emptyList();
    @NotNull
    private static final Setting<List<String>> ALLOW_LIST;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;
    @NotNull
    private static final Setting<List<String>> HOST_DENY_LIST;

    private static final Setting EMAIL_USERNAME$lambda$0(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, (Setting)DestinationSettings.Companion.fallback(key, LegacyOpenDistroDestinationSettings.Companion.getEMAIL_USERNAME(), "plugins", "opendistro"), (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_PASSWORD$lambda$1(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, (Setting)DestinationSettings.Companion.fallback(key, LegacyOpenDistroDestinationSettings.Companion.getEMAIL_PASSWORD(), "plugins", "opendistro"), (Setting.Property[])new Setting.Property[0]);
    }

    static {
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting = Setting.listSetting((String)"plugins.alerting.destination.allow_list", LegacyOpenDistroDestinationSettings.Companion.getALLOW_LIST(), Function.identity(), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"listSetting(...)");
        ALLOW_LIST = setting;
        Setting.AffixSetting affixSetting = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", DestinationSettings::EMAIL_USERNAME$lambda$0, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting, (String)"affixKeySetting(...)");
        EMAIL_USERNAME = affixSetting;
        Setting.AffixSetting affixSetting2 = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", DestinationSettings::EMAIL_PASSWORD$lambda$1, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting2, (String)"affixKeySetting(...)");
        EMAIL_PASSWORD = affixSetting2;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final};
        Setting setting2 = Setting.listSetting((String)"plugins.destination.host.deny_list", LegacyOpenDistroDestinationSettings.Companion.getHOST_DENY_LIST(), Function.identity(), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting2, (String)"listSetting(...)");
        HOST_DENY_LIST = setting2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J3\u0010\u001f\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00052\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H 0\u0010H\u0002\u00a2\u0006\u0002\u0010\"J<\u0010#\u001a\n\u0012\u0004\u0012\u0002H \u0018\u00010\f\"\u0004\b\u0000\u0010 2\u0006\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H 0\u00102\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\b0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/opensearch/alerting/settings/DestinationSettings$Companion;", "", "<init>", "()V", "DESTINATION_SETTING_PREFIX", "", "EMAIL_DESTINATION_SETTING_PREFIX", "ALLOW_LIST_NONE", "", "getALLOW_LIST_NONE", "()Ljava/util/List;", "ALLOW_LIST", "Lorg/opensearch/common/settings/Setting;", "getALLOW_LIST", "()Lorg/opensearch/common/settings/Setting;", "EMAIL_USERNAME", "Lorg/opensearch/common/settings/Setting$AffixSetting;", "Lorg/opensearch/core/common/settings/SecureString;", "getEMAIL_USERNAME", "()Lorg/opensearch/common/settings/Setting$AffixSetting;", "EMAIL_PASSWORD", "getEMAIL_PASSWORD", "HOST_DENY_LIST", "getHOST_DENY_LIST", "loadDestinationSettings", "", "Lorg/opensearch/alerting/settings/DestinationSettings$Companion$SecureDestinationSettings;", "settings", "Lorg/opensearch/common/settings/Settings;", "getSecureDestinationSettings", "emailAccountName", "getEmailSettingValue", "T", "emailSetting", "(Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Lorg/opensearch/common/settings/Setting$AffixSetting;)Ljava/lang/Object;", "fallback", "key", "affixSetting", "regex", "replacement", "SecureDestinationSettings", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getALLOW_LIST_NONE() {
            return ALLOW_LIST_NONE;
        }

        @NotNull
        public final Setting<List<String>> getALLOW_LIST() {
            return ALLOW_LIST;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_USERNAME() {
            return EMAIL_USERNAME;
        }

        @NotNull
        public final Setting.AffixSetting<SecureString> getEMAIL_PASSWORD() {
            return EMAIL_PASSWORD;
        }

        @NotNull
        public final Setting<List<String>> getHOST_DENY_LIST() {
            return HOST_DENY_LIST;
        }

        @NotNull
        public final Map<String, SecureDestinationSettings> loadDestinationSettings(@NotNull Settings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Set emailAccountNames = settings.getGroups(DestinationSettings.EMAIL_DESTINATION_SETTING_PREFIX).keySet();
            Map emailAccounts = new LinkedHashMap();
            for (String emailAccountName : emailAccountNames) {
                SecureDestinationSettings it;
                if (this.getSecureDestinationSettings(settings, emailAccountName) == null) continue;
                boolean bl = false;
                emailAccounts.put(emailAccountName, it);
            }
            return emailAccounts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SecureDestinationSettings getSecureDestinationSettings(Settings settings, String emailAccountName) {
            SecureDestinationSettings secureDestinationSettings;
            SecureString secureString = this.getEmailSettingValue(settings, emailAccountName, this.getEMAIL_USERNAME());
            if (secureString != null) {
                Closeable closeable = (Closeable)secureString;
                Throwable throwable = null;
                try {
                    SecureDestinationSettings secureDestinationSettings2;
                    SecureString emailUsername = (SecureString)closeable;
                    boolean bl = false;
                    SecureString secureString2 = Companion.getEmailSettingValue(settings, emailAccountName, Companion.getEMAIL_PASSWORD());
                    if (secureString2 != null) {
                        Closeable closeable2 = (Closeable)secureString2;
                        Throwable throwable2 = null;
                        try {
                            SecureString emailPassword = (SecureString)closeable2;
                            boolean bl2 = false;
                            SecureString secureString3 = emailUsername.clone();
                            Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"clone(...)");
                            SecureString secureString4 = emailPassword.clone();
                            Intrinsics.checkNotNullExpressionValue((Object)secureString4, (String)"clone(...)");
                            SecureDestinationSettings secureDestinationSettings3 = new SecureDestinationSettings(secureString3, secureString4);
                            secureDestinationSettings2 = secureDestinationSettings3;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                    } else {
                        secureDestinationSettings2 = null;
                    }
                    SecureDestinationSettings secureDestinationSettings4 = secureDestinationSettings2;
                    secureDestinationSettings = secureDestinationSettings4;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                secureDestinationSettings = null;
            }
            return secureDestinationSettings;
        }

        private final <T> T getEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
            Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
            return (T)concreteSetting.get(settings);
        }

        private final <T> Setting<T> fallback(String key, Setting.AffixSetting<T> affixSetting, String regex, String replacement) {
            Setting setting;
            if (Intrinsics.areEqual((Object)"_na_", (Object)key)) {
                setting = affixSetting.getConcreteSettingForNamespace(key);
            } else {
                CharSequence charSequence = key;
                String string = regex;
                setting = affixSetting.getConcreteSetting(new Regex(string).replace(charSequence, replacement));
            }
            return setting;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/opensearch/alerting/settings/DestinationSettings$Companion$SecureDestinationSettings;", "", "emailUsername", "Lorg/opensearch/core/common/settings/SecureString;", "emailPassword", "<init>", "(Lorg/opensearch/core/common/settings/SecureString;Lorg/opensearch/core/common/settings/SecureString;)V", "getEmailUsername", "()Lorg/opensearch/core/common/settings/SecureString;", "getEmailPassword", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "opensearch-alerting"})
        public static final class SecureDestinationSettings {
            @NotNull
            private final SecureString emailUsername;
            @NotNull
            private final SecureString emailPassword;

            public SecureDestinationSettings(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkNotNullParameter((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkNotNullParameter((Object)emailPassword, (String)"emailPassword");
                this.emailUsername = emailUsername;
                this.emailPassword = emailPassword;
            }

            @NotNull
            public final SecureString getEmailUsername() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString getEmailPassword() {
                return this.emailPassword;
            }

            @NotNull
            public final SecureString component1() {
                return this.emailUsername;
            }

            @NotNull
            public final SecureString component2() {
                return this.emailPassword;
            }

            @NotNull
            public final SecureDestinationSettings copy(@NotNull SecureString emailUsername, @NotNull SecureString emailPassword) {
                Intrinsics.checkNotNullParameter((Object)emailUsername, (String)"emailUsername");
                Intrinsics.checkNotNullParameter((Object)emailPassword, (String)"emailPassword");
                return new SecureDestinationSettings(emailUsername, emailPassword);
            }

            public static /* synthetic */ SecureDestinationSettings copy$default(SecureDestinationSettings secureDestinationSettings, SecureString secureString, SecureString secureString2, int n, Object object) {
                if ((n & 1) != 0) {
                    secureString = secureDestinationSettings.emailUsername;
                }
                if ((n & 2) != 0) {
                    secureString2 = secureDestinationSettings.emailPassword;
                }
                return secureDestinationSettings.copy(secureString, secureString2);
            }

            @NotNull
            public String toString() {
                return "SecureDestinationSettings(emailUsername=" + this.emailUsername + ", emailPassword=" + this.emailPassword + ")";
            }

            public int hashCode() {
                int result = this.emailUsername.hashCode();
                result = result * 31 + this.emailPassword.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SecureDestinationSettings)) {
                    return false;
                }
                SecureDestinationSettings secureDestinationSettings = (SecureDestinationSettings)other;
                if (!Intrinsics.areEqual((Object)this.emailUsername, (Object)secureDestinationSettings.emailUsername)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.emailPassword, (Object)secureDestinationSettings.emailPassword);
            }
        }
    }
}

