/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.WrappedRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;

public class WrappedMaterialsProvider
implements EncryptionMaterialsProvider {
    private final Key wrappingKey;
    private final Key unwrappingKey;
    private final KeyPair sigPair;
    private final SecretKey macKey;
    private final Map<String, String> description;

    public WrappedMaterialsProvider(Key wrappingKey, Key unwrappingKey, KeyPair signingPair) {
        this(wrappingKey, unwrappingKey, signingPair, Collections.emptyMap());
    }

    public WrappedMaterialsProvider(Key wrappingKey, Key unwrappingKey, KeyPair signingPair, Map<String, String> description) {
        this.wrappingKey = wrappingKey;
        this.unwrappingKey = unwrappingKey;
        this.sigPair = signingPair;
        this.macKey = null;
        this.description = Collections.unmodifiableMap(new HashMap<String, String>(description));
    }

    public WrappedMaterialsProvider(Key wrappingKey, Key unwrappingKey, SecretKey macKey) {
        this(wrappingKey, unwrappingKey, macKey, Collections.emptyMap());
    }

    public WrappedMaterialsProvider(Key wrappingKey, Key unwrappingKey, SecretKey macKey, Map<String, String> description) {
        this.wrappingKey = wrappingKey;
        this.unwrappingKey = unwrappingKey;
        this.sigPair = null;
        this.macKey = macKey;
        this.description = Collections.unmodifiableMap(new HashMap<String, String>(description));
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        try {
            if (this.macKey != null) {
                return new WrappedRawMaterials(this.wrappingKey, this.unwrappingKey, this.macKey, context.getMaterialDescription());
            }
            return new WrappedRawMaterials(this.wrappingKey, this.unwrappingKey, this.sigPair, context.getMaterialDescription());
        }
        catch (GeneralSecurityException ex) {
            throw new DynamoDBMappingException("Unable to decrypt envelope key", (Throwable)ex);
        }
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        try {
            if (this.macKey != null) {
                return new WrappedRawMaterials(this.wrappingKey, this.unwrappingKey, this.macKey, this.description);
            }
            return new WrappedRawMaterials(this.wrappingKey, this.unwrappingKey, this.sigPair, this.description);
        }
        catch (GeneralSecurityException ex) {
            throw new DynamoDBMappingException("Unable to encrypt envelope key", (Throwable)ex);
        }
    }

    @Override
    public void refresh() {
    }
}

