/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class StructuredDataTerminal {
    private final ByteBuffer value;
    private final ByteBuffer typeId;

    protected StructuredDataTerminal(BuilderImpl builder) {
        this.value = builder.value();
        this.typeId = builder.typeId();
    }

    public ByteBuffer value() {
        return this.value;
    }

    public ByteBuffer typeId() {
        return this.typeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer value;
        protected ByteBuffer typeId;

        protected BuilderImpl() {
        }

        protected BuilderImpl(StructuredDataTerminal model) {
            this.value = model.value();
            this.typeId = model.typeId();
        }

        @Override
        public Builder value(ByteBuffer value) {
            this.value = value;
            return this;
        }

        @Override
        public ByteBuffer value() {
            return this.value;
        }

        @Override
        public Builder typeId(ByteBuffer typeId) {
            this.typeId = typeId;
            return this;
        }

        @Override
        public ByteBuffer typeId() {
            return this.typeId;
        }

        @Override
        public StructuredDataTerminal build() {
            if (Objects.isNull(this.value())) {
                throw new IllegalArgumentException("Missing value for required field `value`");
            }
            if (Objects.isNull(this.typeId())) {
                throw new IllegalArgumentException("Missing value for required field `typeId`");
            }
            if (Objects.nonNull(this.typeId()) && this.typeId().remaining() < 2) {
                throw new IllegalArgumentException("The size of `typeId` must be greater than or equal to 2");
            }
            if (Objects.nonNull(this.typeId()) && this.typeId().remaining() > 2) {
                throw new IllegalArgumentException("The size of `typeId` must be less than or equal to 2");
            }
            return new StructuredDataTerminal(this);
        }
    }

    public static interface Builder {
        public Builder value(ByteBuffer var1);

        public ByteBuffer value();

        public Builder typeId(ByteBuffer var1);

        public ByteBuffer typeId();

        public StructuredDataTerminal build();
    }
}

