/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.remote.metadata.client.BulkDataObjectRequest;
import org.opensearch.remote.metadata.client.BulkDataObjectResponse;
import org.opensearch.remote.metadata.client.DataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClientDelegate;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.client.UpdateDataObjectRequest;
import org.opensearch.remote.metadata.client.UpdateDataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class SdkClient {
    private final SdkClientDelegate delegate;
    private final Executor defaultExecutor;
    private final Boolean isMultiTenancyEnabled;
    private final String globalTenantId;
    protected static final String NO_PERMISSION_TO_OPERATE_GLOBAL_RESOURCE = "You don't have permission to operate on this resource!";

    public SdkClient(SdkClientDelegate delegate, Boolean multiTenancy, String globalTenantId) {
        this(delegate, ForkJoinPool.commonPool(), multiTenancy, globalTenantId);
    }

    public SdkClient(SdkClientDelegate delegate, Executor defaultExecutor, Boolean multiTenancy, String globalTenantId) {
        this.delegate = delegate;
        this.defaultExecutor = defaultExecutor;
        this.isMultiTenancyEnabled = multiTenancy;
        this.globalTenantId = globalTenantId;
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId(), false);
        return this.delegate.putDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<PutDataObjectResponse> putDataObjectAsync(PutDataObjectRequest request) {
        return this.putDataObjectAsync(request, this.defaultExecutor);
    }

    public PutDataObjectResponse putDataObject(PutDataObjectRequest request) {
        try {
            return this.putDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request, Executor executor) {
        return this.delegate.getDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<GetDataObjectResponse> getDataObjectAsync(GetDataObjectRequest request) {
        this.validateTenantId(request.tenantId(), true);
        return this.getDataObjectAsync(request, this.defaultExecutor);
    }

    public GetDataObjectResponse getDataObject(GetDataObjectRequest request) {
        try {
            return this.getDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId(), false);
        return this.delegate.updateDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<UpdateDataObjectResponse> updateDataObjectAsync(UpdateDataObjectRequest request) {
        return this.updateDataObjectAsync(request, this.defaultExecutor);
    }

    public UpdateDataObjectResponse updateDataObject(UpdateDataObjectRequest request) {
        try {
            return this.updateDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId(), false);
        return this.delegate.deleteDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<DeleteDataObjectResponse> deleteDataObjectAsync(DeleteDataObjectRequest request) {
        return this.deleteDataObjectAsync(request, this.defaultExecutor);
    }

    public DeleteDataObjectResponse deleteDataObject(DeleteDataObjectRequest request) {
        try {
            return this.deleteDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request, Executor executor) {
        this.validateTenantIds(request.requests());
        return this.delegate.bulkDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<BulkDataObjectResponse> bulkDataObjectAsync(BulkDataObjectRequest request) {
        return this.bulkDataObjectAsync(request, this.defaultExecutor);
    }

    public BulkDataObjectResponse bulkDataObject(BulkDataObjectRequest request) {
        try {
            return this.bulkDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request, Executor executor) {
        this.validateTenantId(request.tenantId(), false);
        return this.delegate.searchDataObjectAsync(request, executor, this.isMultiTenancyEnabled);
    }

    public CompletionStage<SearchDataObjectResponse> searchDataObjectAsync(SearchDataObjectRequest request) {
        return this.searchDataObjectAsync(request, this.defaultExecutor);
    }

    public SearchDataObjectResponse searchDataObject(SearchDataObjectRequest request) {
        try {
            return this.searchDataObjectAsync(request).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            throw ExceptionsHelper.convertToRuntime((Exception)SdkClientUtils.unwrapAndConvertToException(e, new Class[0]));
        }
    }

    public SdkClientDelegate getDelegate() {
        return this.delegate;
    }

    private void validateTenantId(String tenantId, boolean allowGlobalTenantId) {
        if (Boolean.TRUE.equals(this.isMultiTenancyEnabled)) {
            if (Strings.isNullOrEmpty((String)tenantId)) {
                throw new IllegalArgumentException("A tenant ID is required when multitenancy is enabled.");
            }
            if (!allowGlobalTenantId && tenantId.equals(this.globalTenantId)) {
                throw new OpenSearchStatusException(NO_PERMISSION_TO_OPERATE_GLOBAL_RESOURCE, RestStatus.FORBIDDEN, new Object[0]);
            }
        }
    }

    private void validateTenantIds(List<DataObjectRequest> requests) {
        if (Boolean.TRUE.equals(this.isMultiTenancyEnabled) && requests.stream().map(DataObjectRequest::tenantId).anyMatch(Strings::isNullOrEmpty)) {
            throw new IllegalArgumentException("A tenant ID is required for every bulk request when multitenancy is enabled.");
        }
    }

    public CompletionStage<Boolean> isGlobalResource(String index, String id) {
        return this.delegate.isGlobalResource(index, id, this.defaultExecutor, this.isMultiTenancyEnabled);
    }
}

