/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.fips.DesBase;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DefaultMultiBlockCipher;
import org.bouncycastle.crypto.internal.OutputLengthException;
import org.bouncycastle.crypto.internal.params.KeyParameter;

class DesEdeEngine
extends DefaultMultiBlockCipher {
    private static final int MAX_BLOCK_COUNT = 65536;
    protected static final int BLOCK_SIZE = 8;
    private WorkingBuffer workingBuf = null;
    private boolean forEncryption;
    private int blockCount;
    private final DesBase desBase = new DesBase();

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        int[] nArray;
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + cipherParameters.getClass().getName());
        }
        byte[] byArray = ((KeyParameter)cipherParameters).getKey();
        if (byArray.length != 24 && byArray.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.forEncryption = bl;
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        int[] nArray2 = this.desBase.generateWorkingKey(bl, byArray2);
        byte[] byArray3 = new byte[8];
        System.arraycopy(byArray, 8, byArray3, 0, byArray3.length);
        int[] nArray3 = this.desBase.generateWorkingKey(!bl, byArray3);
        if (byArray.length == 24) {
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray, 16, byArray4, 0, byArray4.length);
            nArray = this.desBase.generateWorkingKey(bl, byArray4);
        } else {
            nArray = nArray2;
        }
        this.workingBuf = new WorkingBuffer(nArray2, nArray3, nArray);
        this.blockCount = 0;
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) {
        if (this.workingBuf == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (n + 8 > byArray.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (n2 + 8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] byArray3 = new byte[8];
        if (this.forEncryption) {
            if (this.blockCount >= 65536) {
                throw new IllegalStateException("attempt to process more than 65536 blocks with 2-Key TripleDES");
            }
            this.desBase.desFunc(this.workingBuf.workingKey1, byArray, n, byArray3, 0);
            this.desBase.desFunc(this.workingBuf.workingKey2, byArray3, 0, byArray3, 0);
            this.desBase.desFunc(this.workingBuf.workingKey3, byArray3, 0, byArray2, n2);
        } else {
            this.desBase.desFunc(this.workingBuf.workingKey3, byArray, n, byArray3, 0);
            this.desBase.desFunc(this.workingBuf.workingKey2, byArray3, 0, byArray3, 0);
            this.desBase.desFunc(this.workingBuf.workingKey1, byArray3, 0, byArray2, n2);
        }
        ++this.blockCount;
        return 8;
    }

    @Override
    public void reset() {
    }

    private static final class WorkingBuffer {
        private final int[] workingKey1;
        private final int[] workingKey2;
        private final int[] workingKey3;

        WorkingBuffer(int[] nArray, int[] nArray2, int[] nArray3) {
            this.workingKey1 = nArray;
            this.workingKey2 = nArray2;
            this.workingKey3 = nArray3;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.workingKey1 == this.workingKey3) {
                    for (int i = 0; i != this.workingKey1.length; ++i) {
                        this.workingKey1[i] = 0;
                        this.workingKey2[i] = 0;
                    }
                } else {
                    for (int i = 0; i != this.workingKey1.length; ++i) {
                        this.workingKey1[i] = 0;
                        this.workingKey2[i] = 0;
                        this.workingKey3[i] = 0;
                    }
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

