/*!
 * ${copyright}
 */
sap.ui.define([
	"sap/ui/core/qunit/analytics/o4aFakeService"
], function (o4aFakeService) {
	"use strict";
	/**
	 * Responses for a Batch Request during the TBA Context Loading Tests
	 */
	o4aFakeService.addResponse({
		batch: true,
		uri: [
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=ActualCosts,Currency&$top=100&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,ActualCosts,Currency&$orderby=CostCenter%20asc&$top=120&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,Currency&$top=0&$inlinecount=allpages"
			],
		header: o4aFakeService.headers.BATCH,
		content: "--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 364\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 267\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664656587715361\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"Currency\":\"USD\",\"ActualCosts\":\"11775332\"}],\"__count\":\"1\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 2442\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 2344\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207061\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1588416\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207062\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"Currency\":\"USD\",\"ActualCosts\":\"1398408\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207063\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1547326\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207064\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"1542211\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207065\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"Currency\":\"USD\",\"ActualCosts\":\"1690110\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207066\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"Currency\":\"USD\",\"ActualCosts\":\"1190663\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207067\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"Currency\":\"USD\",\"ActualCosts\":\"1403813\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207068\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"661910\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664657803207069\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"752475\"}],\"__count\":\"9\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 388\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 291\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'28664659135735621\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\"}],\"__count\":\"106\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0--\r\n" +
				""
	});

	o4aFakeService.addResponse({
		batch: true,
		uri: [
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,ActualCosts,Currency&$filter=(CostCenter%20eq%20%27100-1000%27)&$orderby=CostCenter%20asc,CostElement%20asc&$top=120&$inlinecount=allpages"
			],
		header: o4aFakeService.headers.BATCH,
		content: "--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 364\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 267\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711441\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711442\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"132025\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711443\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"44532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711444\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"12521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711445\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711446\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"675652\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711447\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711448\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"352126\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'23629659555711449\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"76521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'236296595557114410\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"9145\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'236296595557114411\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7589\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'236296595557114412\')\",\"type\":\"fake.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"11265\"}],\"__count\":\"12\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0--\r\n" +
				""
	});

	/**
	 * Responses for a Batch Request with the noPaging option
	 */
	o4aFakeService.addResponse({
		batch: true,
		uri: [
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=ActualCosts,Currency&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,ActualCosts,Currency&$orderby=CostCenter%20asc&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,Currency&$top=0&$inlinecount=allpages"
			],
		header: o4aFakeService.headers.BATCH,
		content: "--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 364\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 283\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719700005687341\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"Currency\":\"USD\",\"ActualCosts\":\"11775332\"}],\"__count\":\"1\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 2442\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 2488\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399181\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1588416\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399182\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"Currency\":\"USD\",\"ActualCosts\":\"1398408\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399183\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1547326\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399184\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"1542211\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399185\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"Currency\":\"USD\",\"ActualCosts\":\"1690110\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399186\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"Currency\":\"USD\",\"ActualCosts\":\"1190663\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399187\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"Currency\":\"USD\",\"ActualCosts\":\"1403813\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399188\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"661910\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719701153399189\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"752475\"}],\"__count\":\"9\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 404\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 307\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'141719702397770151\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\"}],\"__count\":\"106\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0--\r\n" +
				""
	});

	/**
	 * Responses for an AutoExpand Batch Request with the noPaging option
	 */
	o4aFakeService.addResponse({
		batch: true,
		uri: [
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=ActualCosts,Currency&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,Currency&$top=0&$inlinecount=allpages",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,ActualCosts,Currency&$orderby=CostCenter%20asc",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,ActualCosts,Currency&$orderby=CostCenter%20asc,CostElement%20asc",
				"ActualPlannedCosts(P_ControllingArea=\'US01\',P_CostCenter=\'100-1000\',P_CostCenterTo=\'999-9999\')/Results?$select=CostCenter,CostElement,Currency,ActualCosts&$orderby=CostCenter%20asc,CostElement%20asc,Currency%20asc"
			],
		header: o4aFakeService.headers.BATCH,
		content: "--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 380\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 283\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363798229866231\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"Currency\":\"USD\",\"ActualCosts\":\"11775332\"}],\"__count\":\"1\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 404\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 307\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363799323047831\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\"}],\"__count\":\"106\"}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 2572\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 2474\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528451\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1588416\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528452\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"Currency\":\"USD\",\"ActualCosts\":\"1398408\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528453\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"1547326\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528454\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"1542211\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528455\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"Currency\":\"USD\",\"ActualCosts\":\"1690110\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528456\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"Currency\":\"USD\",\"ActualCosts\":\"1190663\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528457\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"Currency\":\"USD\",\"ActualCosts\":\"1403813\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528458\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"Currency\":\"USD\",\"ActualCosts\":\"661910\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363800462528459\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"Currency\":\"USD\",\"ActualCosts\":\"752475\"}]}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 31394\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 31295\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746521\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746522\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"132025\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746523\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"44532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746524\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"12521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746525\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746526\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"675652\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746527\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746528\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"352126\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363801803746529\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"76521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465210\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"9145\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465211\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7589\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465212\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"11265\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465213\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"97523\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465214\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"133687\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465215\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"26524\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465216\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"20125\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465217\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4158\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465218\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"597568\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465219\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"121586\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465220\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"299847\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465221\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"73658\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465222\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"6854\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465223\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7124\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465224\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"9754\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465225\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"113542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465226\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"75143\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465227\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"28645\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465228\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"11245\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465229\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"7024\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465230\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"678453\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465231\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"149543\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465232\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"365419\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465233\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"76846\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465234\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"9654\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465235\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"11658\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465236\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"20154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465237\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"145687\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465238\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"99546\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465239\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"42514\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465240\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"13254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465241\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465242\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"678456\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465243\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"127569\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465244\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"325478\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465245\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"70214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465246\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"10543\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465247\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"9254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465248\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"13542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465249\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"132547\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465250\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"97845\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465251\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"33569\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465252\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"9754\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465253\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6710\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465254\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"740256\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465255\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"150368\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465256\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"388459\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465257\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"80245\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465258\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"11236\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465259\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"12598\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465260\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"26523\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465261\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"150236\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465262\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"108452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465263\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"49563\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465264\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"5412\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465265\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6851\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465266\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"415853\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465267\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"82561\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465268\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"275623\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465269\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"50216\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465270\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"16854\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465271\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7500\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465272\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"21542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465273\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"112512\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465274\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"77452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465275\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"33526\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465276\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"10254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465277\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4512\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465278\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"610452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465279\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"125354\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465280\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"332156\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465281\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"70213\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465282\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"8954\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465283\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"8215\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465284\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"10213\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465285\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"41201\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465286\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"66521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465287\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"26321\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465288\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"2154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465289\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"260321\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465290\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"66235\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465291\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"134652\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465292\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"36214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465293\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"7951\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465294\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"6125\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465295\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"14215\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465296\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"36214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465297\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"49514\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465298\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"22154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638018037465299\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"3741\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652100\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"326014\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652101\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"66021\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652102\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"180542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652103\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"37541\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652104\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"7741\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652105\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"6451\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380180374652106\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"16542\"}]}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0\r\n" +
				"Content-Type: application/http\r\n" +
				"Content-Length: 31394\r\n" +
				"content-transfer-encoding: binary\r\n" +
				"\r\n" +
				"HTTP/1.1 200 OK\r\n" +
				"Content-Type: application/json\r\n" +
				"content-language: en-US\r\n" +
				"Content-Length: 31295\r\n" +
				"\r\n" +
				"{\"d\":{\"results\":[{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616901\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616902\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"132025\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616903\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"44532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616904\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"12521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616905\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4532\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616906\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"675652\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616907\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"131254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616908\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"352126\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'142363802978616909\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"76521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169010\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"9145\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169011\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7589\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169012\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"11265\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169013\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"97523\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169014\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"133687\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169015\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"26524\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169016\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"20125\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169017\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4158\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169018\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"597568\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169019\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"121586\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169020\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"299847\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169021\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"73658\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169022\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"6854\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169023\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7124\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169024\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"100-1100\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"9754\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169025\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"113542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169026\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"75143\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169027\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"28645\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169028\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"11245\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169029\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"7024\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169030\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"678453\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169031\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"149543\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169032\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"365419\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169033\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"76846\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169034\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"9654\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169035\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"11658\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169036\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"20154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169037\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"145687\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169038\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"99546\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169039\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"42514\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169040\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"13254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169041\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169042\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"678456\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169043\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"127569\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169044\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"325478\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169045\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"70214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169046\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"10543\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169047\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"9254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169048\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-2000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"13542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169049\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"132547\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169050\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"97845\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169051\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"33569\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169052\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"9754\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169053\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6710\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169054\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"740256\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169055\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"150368\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169056\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"388459\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169057\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"80245\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169058\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"11236\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169059\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"12598\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169060\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-3000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"26523\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169061\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"150236\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169062\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"108452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169063\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"49563\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169064\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"5412\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169065\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"6851\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169066\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"415853\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169067\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"82561\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169068\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"275623\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169069\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"50216\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169070\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"16854\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169071\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"7500\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169072\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-4000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"21542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169073\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"112512\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169074\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"77452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169075\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"33526\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169076\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"417900\",\"Currency\":\"USD\",\"ActualCosts\":\"10254\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169077\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"4512\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169078\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"610452\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169079\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"125354\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169080\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"332156\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169081\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"70213\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169082\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"8954\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169083\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"8215\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169084\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"200-5000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"10213\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169085\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"41201\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169086\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"66521\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169087\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"26321\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169088\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"2154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169089\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"260321\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169090\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"66235\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169091\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"134652\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169092\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"36214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169093\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"7951\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169094\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"6125\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169095\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-1000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"14215\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169096\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"400020\",\"Currency\":\"USD\",\"ActualCosts\":\"36214\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169097\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"400021\",\"Currency\":\"USD\",\"ActualCosts\":\"49514\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169098\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"410050\",\"Currency\":\"USD\",\"ActualCosts\":\"22154\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'1423638029786169099\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"421000\",\"Currency\":\"USD\",\"ActualCosts\":\"3741\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690100\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"430100\",\"Currency\":\"USD\",\"ActualCosts\":\"326014\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690101\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"435000\",\"Currency\":\"USD\",\"ActualCosts\":\"66021\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690102\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"440001\",\"Currency\":\"USD\",\"ActualCosts\":\"180542\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690103\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"449000\",\"Currency\":\"USD\",\"ActualCosts\":\"37541\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690104\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"474240\",\"Currency\":\"USD\",\"ActualCosts\":\"7741\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690105\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"476900\",\"Currency\":\"USD\",\"ActualCosts\":\"6451\"},{\"__metadata\": {\"uri\":\"http://o4aFakeService:8080/ActualPlannedCostsResults(\'14236380297861690106\')\",\"type\":\"tmp.u012345.cca.CCA.ActualPlannedCostsResultsType\"},\"CostCenter\":\"300-2000\",\"CostElement\":\"478000\",\"Currency\":\"USD\",\"ActualCosts\":\"16542\"}]}}\r\n" +
				"--AAD136757C5CF75E21C04F59B8682CEA0--\r\n" +
				""
	});
});