/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringConfigurator;

public class SmallStringSelectionConfigurator<C extends DataObject>
extends StringConfigurator<C>
implements ActionListener {
    private static final long serialVersionUID = 8434413547241922267L;
    private ButtonGroup buttonGroup;

    public SmallStringSelectionConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.initialize();
    }

    private void initialize() {
        String[] choices = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).choices();
        this.getBottomPanel().setLayout(new FlowLayout(3));
        this.buttonGroup = new ButtonGroup();
        for (String choice : choices) {
            JRadioButton button = new JRadioButton(choice);
            this.buttonGroup.add(button);
            this.getBottomPanel().add(button);
            button.addActionListener(this);
        }
    }

    @Override
    protected void refresh(String string) {
        for (JRadioButton button : this.getButtons()) {
            if (!button.getText().equals(string)) continue;
            button.setSelected(true);
            return;
        }
    }

    @Override
    protected void _actionPerformed(ActionEvent e) {
        JRadioButton button = (JRadioButton)e.getSource();
        this.applyValue(button.getText());
    }

    private List<JRadioButton> getButtons() {
        LinkedList<JRadioButton> list = new LinkedList<JRadioButton>();
        Enumeration<AbstractButton> buttons = this.buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)buttons.nextElement();
            list.add(button);
        }
        return list;
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        for (JRadioButton button : this.getButtons()) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public void focus() {
    }
}

