/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigObject;
import com.sun.j3d.utils.universe.ConfigView;
import com.sun.j3d.utils.universe.ConfigViewPlatformBehavior;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.util.ArrayList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Matrix4d;

class ConfigViewPlatform
extends ConfigObject {
    private boolean allowPolicyRead = false;
    private boolean allowLocalToVworldRead = false;
    private boolean nominalViewingTransform = false;
    private Transform3D initialViewingTransform = null;
    private ArrayList configViews = new ArrayList();
    private Viewer[] viewers = null;
    ViewingPlatform viewingPlatform = null;
    int viewAttachPolicy = -1;
    ConfigViewPlatformBehavior configBehavior = null;

    ConfigViewPlatform() {
    }

    @Override
    protected void initialize(ConfigCommand configCommand) {
    }

    @Override
    protected void setProperty(ConfigCommand configCommand) {
        int n = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        if (n != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        String string = (String)objectArray[2];
        Object object = objectArray[3];
        if (string.equals("NominalViewingTransform")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("NominalViewingTransform must be a boolean");
            }
            this.nominalViewingTransform = (Boolean)object;
        } else if (string.equals("InitialViewingTransform")) {
            if (!(object instanceof Matrix4d)) {
                this.syntaxError("InitialViewingTransform must be a Matrix4d");
            }
            this.initialViewingTransform = new Transform3D((Matrix4d)object);
        } else if (string.equals("ViewAttachPolicy")) {
            String string2;
            if (!(object instanceof String)) {
                this.syntaxError("ViewAttachPolicy must be a string");
            }
            if ((string2 = (String)object).equals("NOMINAL_HEAD")) {
                this.viewAttachPolicy = 0;
            } else if (string2.equals("NOMINAL_SCREEN")) {
                this.viewAttachPolicy = 2;
            } else if (string2.equals("NOMINAL_FEET")) {
                this.viewAttachPolicy = 1;
            } else {
                this.syntaxError("Illegal value " + string2 + " for ViewAttachPolicy");
            }
        } else if (string.equals("ViewPlatformBehavior")) {
            if (!(object instanceof String)) {
                this.syntaxError("ViewPlatformBehavior must be a name");
            }
            this.configBehavior = (ConfigViewPlatformBehavior)this.configContainer.findConfigObject("ViewPlatformBehavior", (String)object);
        } else if (string.equals("AllowPolicyRead")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for AllowPolicyRead must be a boolean");
            }
            this.allowPolicyRead = (Boolean)object;
        } else if (string.equals("AllowLocalToVworldRead")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for AllowLocalToVworldRead must be a boolean");
            }
            this.allowLocalToVworldRead = (Boolean)object;
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    void addConfigView(ConfigView configView) {
        this.configViews.add(configView);
    }

    ViewingPlatform createViewingPlatform(int n) {
        int n2;
        if (this.configViews.size() == 0) {
            this.viewers = new Viewer[0];
        } else {
            this.viewers = new Viewer[this.configViews.size()];
            for (int i = 0; i < this.viewers.length; ++i) {
                this.viewers[i] = ((ConfigView)this.configViews.get((int)i)).j3dViewer;
            }
        }
        this.viewingPlatform = new ViewingPlatform(n);
        ViewPlatform viewPlatform = this.viewingPlatform.getViewPlatform();
        if (this.allowPolicyRead) {
            viewPlatform.setCapability(12);
        }
        if (this.allowLocalToVworldRead) {
            viewPlatform.setCapability(11);
        }
        if (this.viewAttachPolicy == -1) {
            n2 = 1;
            for (int i = 0; i < this.viewers.length; ++i) {
                if (this.viewers[i].getView().getWindowEyepointPolicy() == 2) continue;
                n2 = 0;
                break;
            }
            if (n2 != 0) {
                viewPlatform.setViewAttachPolicy(0);
            } else {
                viewPlatform.setViewAttachPolicy(2);
            }
        } else {
            viewPlatform.setViewAttachPolicy(this.viewAttachPolicy);
        }
        for (n2 = 0; n2 < this.viewers.length; ++n2) {
            this.viewers[n2].setViewingPlatform(this.viewingPlatform);
        }
        if (this.nominalViewingTransform) {
            this.viewingPlatform.setNominalViewingTransform();
        }
        if (this.initialViewingTransform != null) {
            TransformGroup transformGroup = this.viewingPlatform.getViewPlatformTransform();
            transformGroup.setTransform(this.initialViewingTransform);
        }
        return this.viewingPlatform;
    }

    void processBehavior() {
        if (this.configBehavior != null) {
            this.viewingPlatform.setViewPlatformBehavior(this.configBehavior.viewPlatformBehavior);
        }
    }
}

