/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4f;

public class Ground3D
extends Object3DBranch {
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private final float originX;
    private final float originY;
    private final float width;
    private final float depth;
    private Content backgroundImageCache;
    private Dimension backgroundImageDimensionCache;

    public Ground3D(Home home, float f, float f2, float f3, float f4, boolean bl) {
        this(home, null, home, f, f2, f3, f4, bl);
    }

    public Ground3D(Home home, UserPreferences userPreferences, Object object, float f, float f2, float f3, float f4, boolean bl) {
        super(home, home, userPreferences, object);
        this.originX = f;
        this.originY = f2;
        this.width = f3;
        this.depth = f4;
        Appearance appearance = new Appearance();
        appearance.setCapability(1);
        appearance.setCapability(3);
        appearance.setCapability(7);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        this.addChild((Node)shape3D);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_COLOR, 0.0f));
        appearance2.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
        appearance2.setTexCoordGeneration(new TexCoordGeneration(0, 0, new Vector4f(1.0f, 0.0f, 0.0f, 0.5f), new Vector4f(0.0f, 1.0f, -1.0f, 0.5f)));
        appearance2.setCapability(3);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance2.setRenderingAttributes(renderingAttributes);
        appearance2.setCapability(12);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        Box box = new Box(0.5f, 0.0f, 0.5f, 17, appearance2);
        Shape3D shape3D2 = box.getShape(4);
        shape3D2.setCapability(14);
        box.removeChild((Node)shape3D2);
        transformGroup.addChild((Node)shape3D2);
        this.addChild((Node)transformGroup);
        this.setCapability(12);
        this.update(bl);
    }

    @Override
    public void update() {
        this.update(false);
    }

    private void update(boolean bl) {
        List<Level> list;
        Home home = (Home)this.getUserData();
        TransformGroup transformGroup = (TransformGroup)this.getChild(1);
        Shape3D shape3D = (Shape3D)transformGroup.getChild(0);
        Appearance appearance = shape3D.getAppearance();
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        BackgroundImage backgroundImage = null;
        if (home.getEnvironment().isBackgroundImageVisibleOnGround3D()) {
            list = home.getLevels();
            if (list.size() > 0) {
                for (int i = list.size() - 1; i >= 0; --i) {
                    Level level = list.get(i);
                    if (level.getElevation() != 0.0f || !level.isViewableAndVisible() || level.getBackgroundImage() == null || !level.getBackgroundImage().isVisible()) continue;
                    backgroundImage = level.getBackgroundImage();
                    break;
                }
            } else if (home.getBackgroundImage() != null && home.getBackgroundImage().isVisible()) {
                backgroundImage = home.getBackgroundImage();
            }
        }
        if (backgroundImage != null) {
            list = backgroundImage;
            TextureManager.getInstance().loadTexture(((BackgroundImage)((Object)list)).getImage(), bl, new TextureManager.TextureObserver(){
                final /* synthetic */ BackgroundImage val$displayedBackgroundImage;
                final /* synthetic */ Appearance val$backgroundImageAppearance;
                final /* synthetic */ TransformGroup val$backgroundImageGroup;
                final /* synthetic */ boolean val$waitTextureLoadingEnd;
                final /* synthetic */ Ground3D this$0;
                {
                    this.val$displayedBackgroundImage = backgroundImage;
                    this.val$backgroundImageAppearance = appearance;
                    this.val$backgroundImageGroup = transformGroup;
                    this.val$waitTextureLoadingEnd = bl;
                    this.this$0 = ground3D;
                }

                @Override
                public void textureUpdated(Texture texture) {
                    try {
                        if (!this.val$displayedBackgroundImage.getImage().equals(this.this$0.backgroundImageCache)) {
                            InputStream inputStream = this.val$displayedBackgroundImage.getImage().openStream();
                            BufferedImage bufferedImage = ImageIO.read(inputStream);
                            this.this$0.backgroundImageDimensionCache = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                            this.this$0.backgroundImageCache = this.val$displayedBackgroundImage.getImage();
                        }
                        float f = this.val$displayedBackgroundImage.getScale();
                        float f2 = f * (float)((Ground3D)this.this$0).backgroundImageDimensionCache.width;
                        float f3 = f * (float)((Ground3D)this.this$0).backgroundImageDimensionCache.height;
                        Transform3D transform3D = new Transform3D();
                        transform3D.setScale(new Vector3d((double)f2, 1.0, (double)f3));
                        transform3D.setTranslation(new Vector3d((double)(f2 / 2.0f - this.val$displayedBackgroundImage.getXOrigin()), 0.0, (double)(f3 / 2.0f - this.val$displayedBackgroundImage.getYOrigin())));
                        this.val$backgroundImageAppearance.setTexture(this.this$0.getContextTexture(texture, this.this$0.getContext()));
                        this.val$backgroundImageGroup.setTransform(transform3D);
                        this.this$0.updateGround(this.val$waitTextureLoadingEnd, new Rectangle2D.Float(-this.val$displayedBackgroundImage.getXOrigin(), -this.val$displayedBackgroundImage.getYOrigin(), f2, f3));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            renderingAttributes.setVisible(true);
        } else {
            renderingAttributes.setVisible(false);
            this.updateGround(bl, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateGround(boolean bl, Rectangle2D rectangle2D) {
        void var11_21;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Home home = (Home)this.getUserData();
        Shape3D shape3D = (Shape3D)this.getChild(0);
        int n = shape3D.numGeometries();
        final Appearance appearance = shape3D.getAppearance();
        HomeTexture homeTexture = home.getEnvironment().getGroundTexture();
        if (homeTexture == null) {
            int n2 = home.getEnvironment().getGroundColor();
            appearance.setMaterial(this.getMaterial(n2, n2, 0.0f));
            appearance.setTexture(null);
            appearance.getTransparencyAttributes().setTransparencyMode(4);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_COLOR, 0.0f));
            appearance.setTextureAttributes(this.getTextureAttributes(homeTexture, true));
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){
                final /* synthetic */ Ground3D this$0;
                {
                    this.this$0 = ground3D;
                }

                @Override
                public void textureUpdated(Texture texture) {
                    appearance.setTexture(this.this$0.getContextTexture(texture, this.this$0.getContext()));
                    TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
                    transparencyAttributes.setTransparencyMode(TextureManager.getInstance().isTextureTransparent(texture) ? 1 : 4);
                }
            });
        }
        Area area = new Area();
        if (rectangle2D != null) {
            area.add(new Area(rectangle2D));
        }
        HashMap<Level, LevelAreas> hashMap = new HashMap<Level, LevelAreas>();
        for (Room object42 : home.getRooms()) {
            object3 = object42.getLevel();
            if (object3 != null && !((Level)object3).isViewable() || !object42.isFloorVisible() || ((float[][])(object2 = object42.getPoints())).length <= 2) continue;
            iterator = new Area(this.getShape((float[][])object2));
            Object object4 = object = object3 != null && ((Level)object3).getElevation() < 0.0f ? this.getUndergroundAreas(hashMap, (Level)object3) : null;
            if (object3 == null || ((Level)object3).getElevation() <= 0.0f && ((Level)object3).isViewableAndVisible()) {
                area.add((Area)((Object)iterator));
                if (object != null) {
                    ((LevelAreas)object).getRoomArea().add((Area)((Object)iterator));
                }
            }
            if (object == null) continue;
            ((LevelAreas)object).getUndergroundArea().add((Area)((Object)iterator));
        }
        this.updateUndergroundAreasDugByFurniture(hashMap, home.getFurniture());
        for (Wall wall : home.getWalls()) {
            object3 = wall.getLevel();
            if (object3 == null || !((Level)object3).isViewable() || !(((Level)object3).getElevation() < 0.0f)) continue;
            object2 = this.getUndergroundAreas(hashMap, (Level)object3);
            ((LevelAreas)object2).getWallArea().add(new Area(this.getShape(wall.getPoints())));
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            object3 = (LevelAreas)iterator2.next();
            object2 = this.getPoints(((LevelAreas)object3).getWallArea()).iterator();
            while (object2.hasNext()) {
                iterator = (Iterator)((float[][])object2.next());
                if (new Room((float[][])iterator).isClockwise()) continue;
                ((LevelAreas)object3).getUndergroundArea().add(new Area(this.getShape((float[][])iterator)));
            }
        }
        Collections.sort(arrayList, new Comparator<LevelAreas>(){

            @Override
            public int compare(LevelAreas levelAreas, LevelAreas levelAreas2) {
                Level level = levelAreas.getLevel();
                Level level2 = levelAreas2.getLevel();
                int n = -Float.compare(level.getElevation(), level2.getElevation());
                if (n != 0) {
                    return n;
                }
                return level.getElevationIndex() - level2.getElevationIndex();
            }
        });
        Iterator iterator3 = arrayList.iterator();
        while (iterator3.hasNext()) {
            Object object5;
            object3 = (LevelAreas)iterator3.next();
            object2 = ((LevelAreas)object3).getLevel();
            iterator = ((LevelAreas)object3).getUndergroundArea();
            object = (Area)((Area)((Object)iterator)).clone();
            ((LevelAreas)object3).getUndergroundSideArea().add((Area)((Area)((Object)iterator)).clone());
            Iterator<Object> iterator4 = arrayList.iterator();
            while (iterator4.hasNext()) {
                object5 = (LevelAreas)iterator4.next();
                if (!(((LevelAreas)object5).getLevel().getElevation() < ((Level)object2).getElevation())) continue;
                for (float[][] fArray : this.getPoints(((LevelAreas)object5).getUndergroundArea())) {
                    if (new Room(fArray).isClockwise()) continue;
                    Area area2 = new Area(this.getShape(fArray));
                    ((Area)((Object)iterator)).subtract(area2);
                    ((LevelAreas)object3).getUndergroundSideArea().add(area2);
                }
            }
            iterator4 = this.getPoints((Area)((Object)iterator)).iterator();
            while (iterator4.hasNext()) {
                object5 = (float[][])iterator4.next();
                if (new Room((float[][])object5).isClockwise()) {
                    Area area3 = new Area(this.getShape((float[][])object5));
                    area3.exclusiveOr((Area)object);
                    area3.subtract((Area)object);
                    ((LevelAreas)object3).getUpperLevelArea().add(area3);
                    continue;
                }
                area.add(new Area(this.getShape((float[][])object5)));
            }
        }
        Iterator iterator5 = arrayList.iterator();
        while (iterator5.hasNext()) {
            object3 = (LevelAreas)iterator5.next();
            object2 = ((LevelAreas)object3).getRoomArea();
            if (object2 == null) continue;
            iterator = ((LevelAreas)object3).getUndergroundArea();
            ((Area)((Object)iterator)).subtract((Area)object2);
        }
        Area area4 = new Area(this.getShape(new float[][]{{this.originX, this.originY}, {this.originX, this.originY + this.depth}, {this.originX + this.width, this.originY + this.depth}, {this.originX + this.width, this.originY}}));
        object3 = area.getBounds2D();
        if (!area4.getBounds2D().equals(object3)) {
            object2 = area4;
            if (area.isEmpty()) {
                object3 = new Rectangle2D.Float(Math.max(-5000.0f, this.originX), Math.max(-5000.0f, this.originY), 0.0f, 0.0f);
                ((Rectangle2D)object3).add(Math.min(5000.0f, this.originX + this.width), Math.min(5000.0f, this.originY + this.depth));
            } else {
                ((Rectangle2D)object3).add(Math.max(((RectangularShape)object3).getMinX() - 5000.0, (double)this.originX), Math.max(((RectangularShape)object3).getMinY() - 5000.0, (double)this.originY));
                ((Rectangle2D)object3).add(Math.min(((RectangularShape)object3).getMaxX() + 5000.0, (double)(this.originX + this.width)), Math.min(((RectangularShape)object3).getMaxY() + 5000.0, (double)(this.originY + this.depth)));
            }
            Area area5 = new Area((Shape)object3);
            ((Area)object2).subtract(area5);
            this.addAreaGeometry(shape3D, homeTexture, (Area)object2, 0.0f);
        }
        var11_21.subtract(area);
        arrayList.add(0, new LevelAreas(new Level("Ground", 0.0f, 0.0f, 0.0f), (Area)var11_21));
        float f = 0.0f;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (LevelAreas)iterator.next();
            float f2 = ((LevelAreas)object).getLevel().getElevation();
            this.addAreaGeometry(shape3D, homeTexture, ((LevelAreas)object).getUndergroundArea(), f2);
            if (f - f2 > 0.0f) {
                for (float[][] fArray : this.getPoints(((LevelAreas)object).getUndergroundSideArea())) {
                    this.addAreaSidesGeometry(shape3D, homeTexture, fArray, f2, f - f2);
                }
                this.addAreaGeometry(shape3D, homeTexture, ((LevelAreas)object).getUpperLevelArea(), f);
            }
            f = f2;
        }
        for (int i = n - 1; i >= 0; --i) {
            shape3D.removeGeometry(i);
        }
    }

    private List<float[][]> getPoints(Area area) {
        ArrayList<float[][]> arrayList = new ArrayList<float[][]>();
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>();
        float[] fArray = null;
        PathIterator pathIterator = area.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            float[] fArray2 = new float[2];
            if (pathIterator.currentSegment(fArray2) == 4) {
                if (((float[])arrayList2.get(0))[0] == fArray[0] && ((float[])arrayList2.get(0))[1] == fArray[1]) {
                    arrayList2.remove(arrayList2.size() - 1);
                }
                if (arrayList2.size() > 2) {
                    arrayList.add((float[][])arrayList2.toArray((T[])new float[arrayList2.size()][]));
                }
                arrayList2.clear();
                fArray = null;
            } else {
                if (fArray == null || fArray2[0] != fArray[0] || fArray2[1] != fArray[1]) {
                    arrayList2.add(fArray2);
                }
                fArray = fArray2;
            }
            pathIterator.next();
        }
        return arrayList;
    }

    private LevelAreas getUndergroundAreas(Map<Level, LevelAreas> map, Level level) {
        LevelAreas levelAreas = map.get(level);
        if (levelAreas == null) {
            levelAreas = new LevelAreas(level);
            map.put(level, levelAreas);
        }
        return levelAreas;
    }

    private void updateUndergroundAreasDugByFurniture(Map<Level, LevelAreas> map, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            Level level = homePieceOfFurniture.getLevel();
            if (!(homePieceOfFurniture.getGroundElevation() < 0.0f) || !homePieceOfFurniture.isVisible() || level == null || !level.isViewable() || !(level.getElevation() < 0.0f)) continue;
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                this.updateUndergroundAreasDugByFurniture(map, ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture());
                continue;
            }
            LevelAreas levelAreas = this.getUndergroundAreas(map, level);
            if (homePieceOfFurniture.getStaircaseCutOutShape() == null) {
                levelAreas.getUndergroundArea().add(new Area(this.getShape(homePieceOfFurniture.getPoints())));
                continue;
            }
            levelAreas.getUndergroundArea().add(ModelManager.getInstance().getAreaOnFloor(homePieceOfFurniture));
        }
    }

    private void addAreaGeometry(Shape3D shape3D, HomeTexture homeTexture, Area area, float f) {
        List<float[][]> list = this.getAreaPoints(area, 1.0f, false);
        if (!list.isEmpty()) {
            int n = 0;
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = list.get(i).length;
                n += nArray[i];
            }
            Point3f[] point3fArray = new Point3f[n];
            TexCoord2f[] texCoord2fArray = homeTexture != null ? new TexCoord2f[n] : null;
            int n2 = 0;
            for (float[][] fArray : list) {
                int n3 = 0;
                while (n3 < fArray.length) {
                    float[] fArray2 = fArray[n3];
                    point3fArray[n2] = new Point3f(fArray2[0], f, fArray2[1]);
                    if (homeTexture != null) {
                        texCoord2fArray[n2] = new TexCoord2f(fArray2[0] - this.originX, this.originY - fArray2[1]);
                    }
                    ++n3;
                    ++n2;
                }
            }
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setCoordinates(point3fArray);
            if (homeTexture != null) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, texCoord2fArray);
            }
            geometryInfo.setStripCounts(nArray);
            new NormalGenerator(0.0).generateNormals(geometryInfo);
            shape3D.addGeometry((Geometry)geometryInfo.getIndexedGeometryArray());
        }
    }

    private void addAreaSidesGeometry(Shape3D shape3D, HomeTexture homeTexture, float[][] fArray, float f, float f2) {
        Point3f[] point3fArray = new Point3f[fArray.length * 4];
        TexCoord2f[] texCoord2fArray = homeTexture != null ? new TexCoord2f[point3fArray.length] : null;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            float[] fArray2 = fArray[i];
            float[] fArray3 = fArray[i < fArray.length - 1 ? i + 1 : 0];
            point3fArray[n++] = new Point3f(fArray2[0], f, fArray2[1]);
            point3fArray[n++] = new Point3f(fArray2[0], f + f2, fArray2[1]);
            point3fArray[n++] = new Point3f(fArray3[0], f + f2, fArray3[1]);
            point3fArray[n++] = new Point3f(fArray3[0], f, fArray3[1]);
            if (homeTexture == null) continue;
            float f3 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray3[0], fArray3[1]);
            texCoord2fArray[n - 4] = new TexCoord2f(fArray2[0], f);
            texCoord2fArray[n - 3] = new TexCoord2f(fArray2[0], f + f2);
            texCoord2fArray[n - 2] = new TexCoord2f(fArray2[0] - f3, f + f2);
            texCoord2fArray[n - 1] = new TexCoord2f(fArray2[0] - f3, f);
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(point3fArray);
        if (homeTexture != null) {
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, texCoord2fArray);
        }
        new NormalGenerator(0.0).generateNormals(geometryInfo);
        shape3D.addGeometry((Geometry)geometryInfo.getIndexedGeometryArray());
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
    }

    private static class LevelAreas {
        private Level level;
        private Area undergroundArea;
        private Area roomArea = new Area();
        private Area wallArea = new Area();
        private Area undergroundSideArea = new Area();
        private Area upperLevelArea = new Area();

        public LevelAreas(Level level) {
            this(level, new Area());
        }

        public LevelAreas(Level level, Area area) {
            this.level = level;
            this.undergroundArea = area;
        }

        public Level getLevel() {
            return this.level;
        }

        public Area getUndergroundArea() {
            return this.undergroundArea;
        }

        public Area getRoomArea() {
            return this.roomArea;
        }

        public Area getWallArea() {
            return this.wallArea;
        }

        public Area getUndergroundSideArea() {
            return this.undergroundSideArea;
        }

        public Area getUpperLevelArea() {
            return this.upperLevelArea;
        }
    }
}

