/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInput;
import java.io.IOException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ConstantUtf8;
import org.apache.tomcat.util.bcel.classfile.ElementValue;

public class ElementValuePair {
    private final ElementValue elementValue;
    private final ConstantPool constantPool;
    private final int elementNameIndex;

    ElementValuePair(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this.constantPool = constantPool;
        this.elementNameIndex = dataInput.readUnsignedShort();
        this.elementValue = ElementValue.readElementValue(dataInput, constantPool);
    }

    public String getNameString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }
}

