/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapFragment;
import org.graalvm.visualvm.heapviewer.HeapViewer;
import org.openide.util.Lookup;

public final class HeapContext {
    private final File file;
    private final Lookup.Provider project;
    private final HeapFragment fragment;
    private Collection<HeapContext> otherContexts;

    private HeapContext(File file, Lookup.Provider project, HeapFragment fragment) {
        this.file = file;
        this.project = project;
        this.fragment = fragment;
    }

    public File getFile() {
        return this.file;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public HeapFragment getFragment() {
        return this.fragment;
    }

    public Collection<HeapContext> getOtherContexts() {
        return this.otherContexts;
    }

    public static HeapContext[] allContexts(HeapViewer heapViewer) {
        File file = heapViewer.getFile();
        Lookup.Provider project = heapViewer.getProject();
        List<HeapFragment> fragments = heapViewer.getFragments();
        ArrayList<HeapContext> contexts = new ArrayList<HeapContext>(fragments.size());
        for (HeapFragment fragment : fragments) {
            contexts.add(new HeapContext(file, project, fragment));
        }
        for (HeapContext context : contexts) {
            ArrayList otherContexts = new ArrayList(contexts);
            otherContexts.remove(context);
            context.otherContexts = Collections.unmodifiableCollection(otherContexts);
        }
        return contexts.toArray(new HeapContext[0]);
    }
}

