/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.Exception;
import com.zeroc.Ice.LocalException;
import com.zeroc.IceInternal.OutgoingAsyncBase;
import com.zeroc.IceInternal.ProxyOutgoingAsyncBase;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RequestHandler;
import com.zeroc.IceInternal.RetryException;

public class ConnectionRequestHandler
implements RequestHandler {
    private final Reference _reference;
    private final boolean _response;
    private final ConnectionI _connection;
    private final boolean _compress;

    @Override
    public RequestHandler update(RequestHandler previousHandler, RequestHandler newHandler) {
        try {
            if (previousHandler == this) {
                return newHandler;
            }
            if (previousHandler.getConnection() == this._connection) {
                return newHandler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public int sendAsyncRequest(ProxyOutgoingAsyncBase out) throws RetryException {
        return out.invokeRemote(this._connection, this._compress, this._response);
    }

    @Override
    public void asyncRequestCanceled(OutgoingAsyncBase outgoingAsync, LocalException ex) {
        this._connection.asyncRequestCanceled(outgoingAsync, ex);
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public ConnectionI getConnection() {
        return this._connection;
    }

    public ConnectionRequestHandler(Reference ref, ConnectionI connection, boolean compress) {
        this._reference = ref;
        this._response = this._reference.getMode() == 0;
        this._connection = connection;
        this._compress = compress;
    }
}

