/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import javax.swing.DefaultComboBoxModel;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.AFilterComposerDialog;
import org.freeplane.features.filter.FilterConditionEditor;
import org.freeplane.features.filter.FilterConditions;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.mode.Controller;

class EditFilterAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final FilterController filterController;
    private AFilterComposerDialog filterDialog = null;

    EditFilterAction(FilterController filterController) {
        super("EditFilterAction");
        this.filterController = filterController;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        this.getFilterDialog().show();
    }

    private AFilterComposerDialog getFilterDialog() {
        if (this.filterDialog == null) {
            this.filterDialog = new FilterComposerDialog();
            this.getFilterDialog().setLocationRelativeTo(this.filterController.getFilterToolbar());
            Controller.getCurrentController().getMapViewManager().addMapViewChangeListener(this.filterDialog);
        }
        return this.filterDialog;
    }

    private class FilterComposerDialog
    extends AFilterComposerDialog {
        private static final long serialVersionUID = 1L;

        public FilterComposerDialog() {
            super(TextUtils.getText("filter_dialog"), false, FilterConditionEditor.Variant.FILTER_COMPOSER, null);
        }

        @Override
        protected FilterConditions createModel() {
            DefaultComboBoxModel<ASelectableCondition> conditions = new DefaultComboBoxModel<ASelectableCondition>();
            FilterConditions externalConditionsModel = EditFilterAction.this.filterController.getFilterConditionsModel();
            DefaultComboBoxModel<ASelectableCondition> externalConditions = externalConditionsModel.getConditions();
            for (int i = 3; i < externalConditions.getSize(); ++i) {
                Object element = externalConditions.getElementAt(i);
                conditions.addElement((ASelectableCondition)element);
            }
            Object selectedItem = externalConditions.getSelectedItem();
            if (conditions.getIndexOf(selectedItem) != -1) {
                conditions.setSelectedItem(selectedItem);
            } else {
                conditions.setSelectedItem(null);
            }
            return new FilterConditions(conditions, externalConditionsModel.getPinnedConditionsCount());
        }

        @Override
        protected void applyModel(FilterConditions model, int[] selectedIndices) {
            EditFilterAction.this.filterController.setFilterConditions(model);
        }

        @Override
        protected boolean isSelectionValid(int[] selectedIndices) {
            return true;
        }
    }
}

