/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.core.actions.HTMLViewAction;
import org.netbeans.core.startup.Splash;
import org.netbeans.core.ui.Bundle;
import org.openide.awt.CheckForUpdatesProvider;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProductInformationPanel
extends JPanel
implements HyperlinkListener {
    URL url;
    Icon about;
    private static final String CHECK_FOR_UPDATES_ACTION = "check-for-updates";
    private static final int FONT_SIZE = ProductInformationPanel.getFontSize();
    private JTextPane copyright;
    private JTextPane description;
    private JScrollPane descriptionScrollPane;
    private JLabel imageLabel;

    public ProductInformationPanel() {
        this.initComponents();
        this.imageLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.description.setText(Bundle.LBL_description(ProductInformationPanel.getProductVersionValue(), ProductInformationPanel.getJavaValue(), ProductInformationPanel.getVMValue(), ProductInformationPanel.getOperatingSystemValue(), ProductInformationPanel.getEncodingValue(), ProductInformationPanel.getSystemLocaleValue(), this.getUserDirValue(), Places.getCacheDirectory().getAbsolutePath(), "", FONT_SIZE, ProductInformationPanel.getJavaRuntime()));
        this.description.setCursor(Cursor.getPredefinedCursor(3));
        this.description.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        RequestProcessor.getDefault().post(() -> {
            String updates = ProductInformationPanel.getUpdates();
            SwingUtilities.invokeLater(() -> {
                this.description.setText(Bundle.LBL_description(ProductInformationPanel.getProductVersionValue(), ProductInformationPanel.getJavaValue(), ProductInformationPanel.getVMValue(), ProductInformationPanel.getOperatingSystemValue(), ProductInformationPanel.getEncodingValue(), ProductInformationPanel.getSystemLocaleValue(), this.getUserDirValue(), Places.getCacheDirectory().getAbsolutePath(), updates, FONT_SIZE, ProductInformationPanel.getJavaRuntime()));
                this.descriptionScrollPane.setVerticalScrollBarPolicy(22);
                this.description.setCursor(null);
                this.description.revalidate();
                this.description.setCaretPosition(0);
            });
        });
        this.description.setCaretPosition(0);
        this.description.addHyperlinkListener(this);
        this.copyright.addHyperlinkListener(this);
        this.copyright.setBackground(this.getBackground());
        this.copyright.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.about = ImageUtilities.image2Icon((Image)Splash.loadContent((boolean)true));
        this.imageLabel.setIcon(this.about);
        this.imageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    ProductInformationPanel.this.url = new URL(NbBundle.getMessage(ProductInformationPanel.class, (String)"URL_ON_IMG"));
                    ProductInformationPanel.this.showUrl();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        });
        this.description.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ENTERED == e.getEventType()) {
                if (CHECK_FOR_UPDATES_ACTION.equals(e.getDescription())) {
                    this.description.setToolTipText(Bundle.check_for_updates());
                } else if (e.getURL() != null) {
                    this.description.setToolTipText(e.getURL().toExternalForm());
                }
            } else if (HyperlinkEvent.EventType.EXITED == e.getEventType()) {
                this.description.setToolTipText(null);
            } else if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                if (CHECK_FOR_UPDATES_ACTION.equals(e.getDescription())) {
                    ProductInformationPanel.checkForUpdates();
                } else {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                }
            }
        });
    }

    private void initComponents() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton();
        JScrollPane copyrightScrollPane = new JScrollPane();
        this.copyright = new JTextPane();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextPane();
        JPanel imagePanel = new JPanel();
        this.imageLabel = new JLabel();
        buttonPanel.setLayout(new GridBagLayout());
        closeButton.setMnemonic(NbBundle.getMessage(ProductInformationPanel.class, (String)"MNE_Close").charAt(0));
        closeButton.setText(NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProductInformationPanel.this.closeButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        buttonPanel.add((Component)closeButton, gridBagConstraints);
        copyrightScrollPane.setBorder(null);
        this.copyright.setEditable(false);
        this.copyright.setBorder(null);
        this.copyright.setContentType("text/html");
        this.copyright.setText(ProductInformationPanel.getCopyrightText());
        this.copyright.setMinimumSize(new Dimension(50, 0));
        this.copyright.setCaretPosition(0);
        this.copyright.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProductInformationPanel.this.copyrightMouseClicked(evt);
            }
        });
        copyrightScrollPane.setViewportView(this.copyright);
        this.descriptionScrollPane.setHorizontalScrollBarPolicy(32);
        this.descriptionScrollPane.setVerticalScrollBarPolicy(21);
        this.description.setEditable(false);
        this.description.setContentType("text/html");
        this.description.setText("<div style=\"font-size: 12pt; font-family: Verdana, 'Verdana CE',  Arial, 'Arial CE', 'Lucida Grande CE', lucida, 'Helvetica CE', sans-serif;\">\n    <b>Product Version:</b> {0}<br> <b>Java:</b> {1}; {2}<br> <b>System:</b> {3}; {4}; {5}<br><b>Userdir:</b> {6}</div>");
        this.descriptionScrollPane.setViewportView(this.description);
        imagePanel.setLayout(new BorderLayout());
        this.imageLabel.setHorizontalAlignment(0);
        imagePanel.add((Component)this.imageLabel, "Center");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(imagePanel, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE).addComponent(copyrightScrollPane, -1, 190, Short.MAX_VALUE).addComponent(buttonPanel, GroupLayout.Alignment.LEADING, -1, 190, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(imagePanel, -1, 79, Short.MAX_VALUE).addGap(14, 14, 14).addComponent(copyrightScrollPane, -1, 70, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(buttonPanel, -2, -1, -2).addContainerGap()));
    }

    private void copyrightMouseClicked(MouseEvent evt) {
        this.showUrl();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        Window w = SwingUtilities.getWindowAncestor(this);
        w.setVisible(false);
        w.dispose();
    }

    private void showUrl() {
        if (this.url != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(HTMLViewAction.class, (String)"CTL_OpeningBrowser"));
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.url);
        }
    }

    public static String getProductVersionValue() {
        return MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion"), System.getProperty("netbeans.buildnumber"));
    }

    public static String getOperatingSystemValue() {
        return NbBundle.getMessage(ProductInformationPanel.class, (String)"Format_OperatingSystem_Value", (Object)System.getProperty("os.name", "unknown"), (Object)System.getProperty("os.version", "unknown"), (Object)System.getProperty("os.arch", "unknown"));
    }

    public static String getJavaValue() {
        return System.getProperty("java.version", "unknown");
    }

    public static String getVMValue() {
        return System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "");
    }

    public static String getJavaRuntime() {
        return System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", "");
    }

    public static String getSystemLocaleValue() {
        String branding;
        return Locale.getDefault().toString() + ((branding = NbBundle.getBranding()) == null ? "" : " (" + branding + ")");
    }

    private String getUserDirValue() {
        return System.getProperty("netbeans.user");
    }

    public static String getEncodingValue() {
        return System.getProperty("file.encoding", "unknown");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (HyperlinkEvent.EventType.ENTERED == event.getEventType()) {
            this.url = event.getURL();
        } else if (HyperlinkEvent.EventType.EXITED == event.getEventType()) {
            this.url = null;
        }
    }

    private static String getCopyrightText() {
        FileObject[] foArray;
        String copyrighttext = NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_Copyright", (Object)FONT_SIZE);
        FileObject licenseFolder = FileUtil.getConfigFile((String)"About/Licenses");
        if (licenseFolder != null && (foArray = licenseFolder.getChildren()).length > 0) {
            boolean isSomeLicense = false;
            StringWriter sw = new StringWriter();
            for (int i = 0; i < foArray.length; ++i) {
                String curLicense = ProductInformationPanel.loadLicenseText(foArray[i]);
                if (curLicense == null) continue;
                sw.write("<br>" + NbBundle.getMessage(ProductInformationPanel.class, (String)"LBL_AddOnCopyright", (Object)curLicense, (Object)FONT_SIZE));
                isSomeLicense = true;
            }
            if (isSomeLicense) {
                copyrighttext = copyrighttext + sw.toString();
            }
        }
        return copyrighttext;
    }

    private static String loadLicenseText(FileObject fo) {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return null;
            }
        }
        reader.close();
        return string;
    }

    private static String getUpdates() {
        assert (!EventQueue.isDispatchThread()) : "Don't call it from event dispatch thread.";
        CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
        if (checkForUpdatesProvider == null) {
            return "";
        }
        String desc = checkForUpdatesProvider.getContentDescription();
        String string = desc = desc != null ? desc : "";
        if (checkForUpdatesProvider.notifyAvailableUpdates(false)) {
            return Bundle.updates_found(desc.isEmpty() ? desc : Bundle.to_version(desc));
        }
        return desc.isEmpty() ? desc : Bundle.updates_not_found(desc);
    }

    private static void checkForUpdates() {
        assert (EventQueue.isDispatchThread()) : "Call it from event dispatch thread only.";
        CheckForUpdatesProvider checkForUpdatesProvider = (CheckForUpdatesProvider)Lookup.getDefault().lookup(CheckForUpdatesProvider.class);
        if (checkForUpdatesProvider != null) {
            checkForUpdatesProvider.openCheckForUpdatesWizard(true);
        }
    }

    private static int getFontSize() {
        Integer customFontSize = (Integer)UIManager.get("customFontSize");
        if (customFontSize != null) {
            return customFontSize;
        }
        return 12;
    }
}

