# Error Dialog generator
#
# Copyright 2021 cunidev
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gi
gi.require_version('Gtk', '3.0')
from gi.repository import Gtk, Gio, Gdk

from gestures.configfile import ConfigFileHandler
from gestures.gesture import Gesture
from gestures.__version__ import __version__

class ErrorDialog(Gtk.Dialog):
    def backend_not_installed(self,win):
        dialog = Gtk.MessageDialog(
            win, 0, Gtk.MessageType.ERROR, Gtk.ButtonsType.OK, "libinput-gestures backend not found")
        dialog.format_secondary_markup(
            "Make sure it is correctly installed and configured.\n" + \
            "Please refer to <a href=\"https://github.com/bulletmark/libinput-gestures/blob/master/README.md\">this page</a> for more instructions")
        dialog.run()
        dialog.destroy()
