/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorInt32;
import org.itk.simple.VectorUInt32;

public class ExtractImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected ExtractImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.ExtractImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ExtractImageFilter extractImageFilter) {
        return extractImageFilter == null ? 0L : extractImageFilter.swigCPtr;
    }

    protected static long swigRelease(ExtractImageFilter extractImageFilter) {
        long l = 0L;
        if (extractImageFilter != null) {
            if (!extractImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = extractImageFilter.swigCPtr;
            extractImageFilter.swigCMemOwn = false;
            extractImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_ExtractImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ExtractImageFilter() {
        this(SimpleITKJNI.new_ExtractImageFilter(), true);
    }

    public void setSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.ExtractImageFilter_setSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getSize() {
        return new VectorUInt32(SimpleITKJNI.ExtractImageFilter_getSize(this.swigCPtr, this), true);
    }

    public void setIndex(VectorInt32 vectorInt32) {
        SimpleITKJNI.ExtractImageFilter_setIndex(this.swigCPtr, this, VectorInt32.getCPtr(vectorInt32), vectorInt32);
    }

    public VectorInt32 getIndex() {
        return new VectorInt32(SimpleITKJNI.ExtractImageFilter_getIndex(this.swigCPtr, this), true);
    }

    public void setDirectionCollapseToStrategy(DirectionCollapseToStrategyType directionCollapseToStrategyType) {
        SimpleITKJNI.ExtractImageFilter_setDirectionCollapseToStrategy(this.swigCPtr, this, directionCollapseToStrategyType.swigValue());
    }

    public DirectionCollapseToStrategyType getDirectionCollapseToStrategy() {
        return DirectionCollapseToStrategyType.swigToEnum(SimpleITKJNI.ExtractImageFilter_getDirectionCollapseToStrategy(this.swigCPtr, this));
    }

    @Override
    public String getName() {
        return SimpleITKJNI.ExtractImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.ExtractImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.ExtractImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }

    public static final class DirectionCollapseToStrategyType {
        public static final DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOUNKOWN = new DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOUNKOWN");
        public static final DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOIDENTITY = new DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOIDENTITY");
        public static final DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOSUBMATRIX = new DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOSUBMATRIX");
        public static final DirectionCollapseToStrategyType DIRECTIONCOLLAPSETOGUESS = new DirectionCollapseToStrategyType("DIRECTIONCOLLAPSETOGUESS");
        private static DirectionCollapseToStrategyType[] swigValues = new DirectionCollapseToStrategyType[]{DIRECTIONCOLLAPSETOUNKOWN, DIRECTIONCOLLAPSETOIDENTITY, DIRECTIONCOLLAPSETOSUBMATRIX, DIRECTIONCOLLAPSETOGUESS};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static DirectionCollapseToStrategyType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && DirectionCollapseToStrategyType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (DirectionCollapseToStrategyType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(DirectionCollapseToStrategyType.class) + " with value " + n);
        }

        private DirectionCollapseToStrategyType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private DirectionCollapseToStrategyType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private DirectionCollapseToStrategyType(String string, DirectionCollapseToStrategyType directionCollapseToStrategyType) {
            this.swigName = string;
            this.swigValue = directionCollapseToStrategyType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

