/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Implementation of the N4 bias field correction algorithm.


The nonparametric nonuniform intensity normalization (N3) algorithm,
as introduced by Sled et al. in 1998 is a method for correcting
nonuniformity associated with MR images. The algorithm assumes a
simple parametric model (Gaussian) for the bias field and does not
require tissue class segmentation. In addition, there are only a
couple of parameters to tune with the default values performing quite
well. N3 has been publicly available as a set of perl scripts ( https://www.bic.mni.mcgill.ca/ServicesSoftwareAdvancedImageProcessingT
ools/HomePage )

The N4 algorithm, encapsulated with this class, is a variation of the
original N3 algorithm with the additional benefits of an improved
B-spline fitting routine which allows for multiple resolutions to be
used during the correction process. We also modify the iterative
update component of algorithm such that the residual bias field is
continually updated

Notes for the user:
Since much of the image manipulation is done in the log space of the
intensities, input images with negative and small values (&lt; 1) can
produce poor results.

The original authors recommend performing the bias field correction on
a downsampled version of the original image.

A binary mask or a weighted image can be supplied. If a binary mask is
specified, those voxels in the input image which correspond to the
voxels in the mask image are used to estimate the bias field. If a
UseMaskLabel value is set to false (the default), all non-zero voxels
in the MaskImage will be masked; otherwise only voxels in the
MaskImage that match the MaskLabel will be used. If a confidence image
is specified, the input voxels are weighted in the b-spline fitting
routine according to the confidence voxel values.

The filter returns the corrected image. If the bias field is wanted,
one can reconstruct it using the class
itkBSplineControlPointImageFilter. See the IJ article and the test
file for an example.

The 'Z' parameter in Sled's 1998 paper is the square root of the class
variable 'm_WienerFilterNoise'.
 The basic algorithm iterates between sharpening the intensity
histogram of the corrected input image and spatially smoothing those
results with a B-spline scalar field estimate of the bias field.


Nicholas J. Tustison
 Contributed by Nicholas J. Tustison, James C. Gee in the Insight
Journal paper: https://doi.org/10.54294/jculxw

REFERENCE
 J.G. Sled, A.P. Zijdenbos and A.C. Evans. "A Nonparametric Method
for Automatic Correction of Intensity Nonuniformity in Data" IEEE
Transactions on Medical Imaging, Vol 17, No 1. Feb 1998.

N.J. Tustison, B.B. Avants, P.A. Cook, Y. Zheng, A. Egan, P.A.
Yushkevich, and J.C. Gee. "N4ITK: Improved N3 Bias Correction" IEEE
Transactions on Medical Imaging, 29(6):1310-1320, June 2010.
See:
 itk::simple::N4BiasFieldCorrection for the procedural interface

 itk::N4BiasFieldCorrectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkN4BiasFieldCorrectionImageFilter.h
*/
public class N4BiasFieldCorrectionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected N4BiasFieldCorrectionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(N4BiasFieldCorrectionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(N4BiasFieldCorrectionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::N4BiasFieldCorrectionImageFilter::~N4BiasFieldCorrectionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_N4BiasFieldCorrectionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::N4BiasFieldCorrectionImageFilter::N4BiasFieldCorrectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  N4BiasFieldCorrectionImageFilter() {
    this(SimpleITKJNI.new_N4BiasFieldCorrectionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetConvergenceThreshold(double ConvergenceThreshold)

Set the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.

*/
public  void setConvergenceThreshold(double ConvergenceThreshold) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setConvergenceThreshold(swigCPtr, this, ConvergenceThreshold);
  }

  /**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetConvergenceThreshold() const

Get the convergence threshold. Convergence is determined by the
coefficient of variation of the difference image between the current
bias field estimate and the previous estimate. If this value is less
than the specified threshold, the algorithm proceeds to the next
fitting level or terminates if it is at the last level.

*/
public  double getConvergenceThreshold() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getConvergenceThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetMaximumNumberOfIterations(std::vector&lt; uint32_t &gt; MaximumNumberOfIterations)

Set the maximum number of iterations specified at each fitting level.
Default = 50.

*/
public  void setMaximumNumberOfIterations(VectorUInt32 MaximumNumberOfIterations) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setMaximumNumberOfIterations(swigCPtr, this, VectorUInt32.getCPtr(MaximumNumberOfIterations), MaximumNumberOfIterations);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::N4BiasFieldCorrectionImageFilter::GetMaximumNumberOfIterations() const

Get the maximum number of iterations specified at each fitting level.
Default = 50.

*/
public  VectorUInt32 getMaximumNumberOfIterations() {
    return new VectorUInt32(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getMaximumNumberOfIterations(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetBiasFieldFullWidthAtHalfMaximum(double BiasFieldFullWidthAtHalfMaximum)

Set the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.

*/
public  void setBiasFieldFullWidthAtHalfMaximum(double BiasFieldFullWidthAtHalfMaximum) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setBiasFieldFullWidthAtHalfMaximum(swigCPtr, this, BiasFieldFullWidthAtHalfMaximum);
  }

  /**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetBiasFieldFullWidthAtHalfMaximum() const

Get the full width at half maximum parameter characterizing the width
of the Gaussian deconvolution. Default = 0.15.

*/
public  double getBiasFieldFullWidthAtHalfMaximum() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getBiasFieldFullWidthAtHalfMaximum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetWienerFilterNoise(double WienerFilterNoise)

Set the noise estimate defining the Wiener filter. Default = 0.01.

*/
public  void setWienerFilterNoise(double WienerFilterNoise) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setWienerFilterNoise(swigCPtr, this, WienerFilterNoise);
  }

  /**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetWienerFilterNoise() const

Get the noise estimate defining the Wiener filter. Default = 0.01.

*/
public  double getWienerFilterNoise() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getWienerFilterNoise(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set number of bins defining the log input intensity histogram. Default
= 200.

*/
public  void setNumberOfHistogramBins(long NumberOfHistogramBins) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setNumberOfHistogramBins(swigCPtr, this, NumberOfHistogramBins);
  }

  /**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfHistogramBins() const

Get number of bins defining the log input intensity histogram. Default
= 200.

*/
public  long getNumberOfHistogramBins() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getNumberOfHistogramBins(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints(uint32_t value)

Set the values of the NumberOfControlPoints vector all to value

*/
public  void setNumberOfControlPoints(VectorUInt32 NumberOfControlPoints) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setNumberOfControlPoints__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(NumberOfControlPoints), NumberOfControlPoints);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetNumberOfControlPoints(uint32_t value)

Set the values of the NumberOfControlPoints vector all to value

*/
public  void setNumberOfControlPoints(long value) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setNumberOfControlPoints__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::N4BiasFieldCorrectionImageFilter::GetNumberOfControlPoints() const

Get the control point grid size defining the B-spline estimate of the
scalar bias field. In each dimension, the B-spline mesh size is equal
to the number of control points in that dimension minus the spline
order. Default = 4 control points in each dimension for a mesh size of
1 in each dimension.

*/
public  VectorUInt32 getNumberOfControlPoints() {
    return new VectorUInt32(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getNumberOfControlPoints(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetSplineOrder(uint32_t SplineOrder)

Set the spline order defining the bias field estimate. Default = 3.

*/
public  void setSplineOrder(long SplineOrder) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setSplineOrder(swigCPtr, this, SplineOrder);
  }

  /**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetSplineOrder() const

Get the spline order defining the bias field estimate. Default = 3.

*/
public  long getSplineOrder() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getSplineOrder(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetUseMaskLabel(bool UseMaskLabel)

Use a mask label for identifying mask functionality. See SetMaskLabel.
Defaults to true.

*/
public  void setUseMaskLabel(boolean UseMaskLabel) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setUseMaskLabel(swigCPtr, this, UseMaskLabel);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::UseMaskLabelOn()

Set the value of UseMaskLabel to true or false respectfully.

*/
public  void useMaskLabelOn() {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_useMaskLabelOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::UseMaskLabelOff()
*/
public  void useMaskLabelOff() {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_useMaskLabelOff(swigCPtr, this);
  }

  /**
bool itk::simple::N4BiasFieldCorrectionImageFilter::GetUseMaskLabel() const

Use a mask label for identifying mask functionality. See SetMaskLabel.
Defaults to true.

*/
public  boolean getUseMaskLabel() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getUseMaskLabel(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::N4BiasFieldCorrectionImageFilter::SetMaskLabel(uint8_t MaskLabel)

Set/Get mask label value. If a binary mask image is specified and if
UseMaskValue is true, only those input image voxels corresponding with
mask image values equal to MaskLabel are used in estimating the bias
field. If a MaskImage is specified and UseMaskLabel is false, all
input image voxels corresponding to non-zero voxels in the MaskImage
are used in estimating the bias field. Default = 1.

*/
public  void setMaskLabel(short MaskLabel) {
    SimpleITKJNI.N4BiasFieldCorrectionImageFilter_setMaskLabel(swigCPtr, this, MaskLabel);
  }

  /**
uint8_t itk::simple::N4BiasFieldCorrectionImageFilter::GetMaskLabel() const

Set/Get mask label value. If a binary mask image is specified and if
UseMaskValue is true, only those input image voxels corresponding with
mask image values equal to MaskLabel are used in estimating the bias
field. If a MaskImage is specified and UseMaskLabel is false, all
input image voxels corresponding to non-zero voxels in the MaskImage
are used in estimating the bias field. Default = 1.

*/
public  short getMaskLabel() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getMaskLabel(swigCPtr, this);
  }

  /**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetCurrentLevel() const

Get the current fitting level. This is a helper function for reporting
observations.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getCurrentLevel() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getCurrentLevel(swigCPtr, this);
  }

  /**
uint32_t itk::simple::N4BiasFieldCorrectionImageFilter::GetElapsedIterations() const

Get the number of elapsed iterations. This is a helper function for
reporting observations.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  long getElapsedIterations() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getElapsedIterations(swigCPtr, this);
  }

  /**
double itk::simple::N4BiasFieldCorrectionImageFilter::GetCurrentConvergenceMeasurement() const

Get the current convergence measurement. This is a helper function for
reporting observations.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getCurrentConvergenceMeasurement() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getCurrentConvergenceMeasurement(swigCPtr, this);
  }

  /**
Image itk::simple::N4BiasFieldCorrectionImageFilter::GetLogBiasFieldAsImage(Image referenceImage) const

The computed log bias field correction. Typically, a reduced size
image is used as input to the N4 filter using something like
itkShrinkImageFilter. Since the output is a corrected version of the
input, the user will probably want to apply the bias field correction
to the full resolution image. Returns the b-spline log bias field
reconstructioned onto the space of the referenceImage parameter. An
input image can be corrected by: input/exp(bias_field).


 This is an active measurement. It may be accessed while the  filter
is being executing in command call-backs and can be  accessed after
execution.

*/
public  Image getLogBiasFieldAsImage(Image referenceImage) {
    return new Image(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getLogBiasFieldAsImage(swigCPtr, this, Image.getCPtr(referenceImage), referenceImage), true);
  }

  /**
std::string itk::simple::N4BiasFieldCorrectionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::N4BiasFieldCorrectionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.N4BiasFieldCorrectionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::N4BiasFieldCorrectionImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::N4BiasFieldCorrectionImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.N4BiasFieldCorrectionImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
