/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.data;

import java.awt.datatransfer.DataFlavor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.LayerTransferable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;

public class LayerTransferData
extends LayerTransferable.Data {
    public static final DataFlavor FLAVOR = ClipboardUtils.newDataFlavor(LayerTransferData.class, "Layer");
    private static final List<DataFlavor> FLAVORS = Arrays.asList(FLAVOR, LayerTransferable.LAYER_DATA);
    private final Layer layer;

    public LayerTransferData(LayerManager layerManager, Layer layer) {
        super(layerManager, Collections.singletonList(layer));
        this.layer = layer;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public List<DataFlavor> getSupportedFlavors() {
        return Collections.unmodifiableList(FLAVORS);
    }

    @Override
    public String toString() {
        return "LayerTransferData [layer=" + this.layer + "]";
    }
}

