/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jsampler.CC;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaUtils;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.SamplerEngine;

class ChannelScreen
extends PixmapPane {
    private final Channel channel;
    private final InstrumentPane instrumentPane;
    private final Channel.StreamVoiceCountPane streamVoiceCountPane;
    private final Channel.VolumePane volumePane;
    private JButton btnInstr = FantasiaUtils.createScreenButton(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
    private final JButton btnEditInstr = FantasiaUtils.createScreenButton(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnEditInstr"));
    private final ScreenButtonBg sbbEditInstr = new ScreenButtonBg(this.btnEditInstr);
    private final JButton btnFxSends = FantasiaUtils.createScreenButton(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnFxSends"));
    private final JButton btnEngine = FantasiaUtils.createScreenButton(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnEngine"));
    private final JPopupMenu menuEngines = new JPopupMenu();
    private final ActionListener guiListener;
    private final Vector<JComponent> components = new Vector();
    private final EventHandler eventHandler = new EventHandler();

    ChannelScreen(final Channel channel) {
        super(Res.gfxChannelScreen);
        this.setPixmapInsets(new Insets(6, 6, 6, 6));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.components.add(this);
        this.channel = channel;
        this.streamVoiceCountPane = new Channel.StreamVoiceCountPane(channel);
        this.components.add(this.streamVoiceCountPane);
        this.volumePane = new Channel.VolumePane(channel);
        this.components.add(this.volumePane);
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.btnInstr.setAlignmentX(0.5f);
        this.btnInstr.setRolloverEnabled(false);
        this.btnInstr.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.components.add(this.btnInstr);
        this.instrumentPane = new InstrumentPane();
        this.components.add(this.instrumentPane);
        this.add(this.instrumentPane);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        JPanel jPanel = new JPanel();
        this.components.add(jPanel);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.5f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 2, 0, 0));
        this.components.add(this.btnFxSends);
        this.btnFxSends.setToolTipText(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnFxSends.tt"));
        this.btnFxSends.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                channel.showFxSendsDialog();
            }
        });
        jPanel.add(this.btnFxSends);
        jPanel.add(Box.createGlue());
        this.components.add(this.btnEngine);
        this.btnEngine.setIcon(Res.iconEngine12);
        this.btnEngine.setIconTextGap(1);
        jPanel.add(this.btnEngine);
        jPanel.add(Box.createGlue());
        jPanel.add(this.streamVoiceCountPane);
        jPanel.add(this.volumePane);
        jPanel.setPreferredSize(new Dimension(260, jPanel.getPreferredSize().height));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        jPanel.setOpaque(false);
        this.add(jPanel);
        this.setPreferredSize(new Dimension(270, 48));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.createEngineMenu();
        this.guiListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChannelScreen.this.getMousePosition(true) != null) {
                    ChannelScreen.this.getHandler().mouseEntered(null);
                } else {
                    ChannelScreen.this.getHandler().mouseExited(null);
                }
            }
        };
    }

    public void addEnhancedMouseListener(MouseListener mouseListener) {
        this.removeEnhancedMouseListener(mouseListener);
        for (JComponent jComponent : this.components) {
            jComponent.addMouseListener(mouseListener);
        }
    }

    public void removeEnhancedMouseListener(MouseListener mouseListener) {
        for (JComponent jComponent : this.components) {
            jComponent.removeMouseListener(mouseListener);
        }
    }

    protected void onDestroy() {
        this.uninstallListeners();
    }

    private void createEngineMenu() {
        for (final SamplerEngine samplerEngine : CC.getSamplerModel().getEngines()) {
            JMenuItem jMenuItem = new JMenuItem(samplerEngine.getName() + " engine");
            jMenuItem.setToolTipText(samplerEngine.getDescription());
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ChannelScreen.this.channel.getModel().setBackendEngineType(samplerEngine.getName());
                }
            });
            this.menuEngines.add(jMenuItem);
        }
    }

    protected void installListeners() {
        this.btnInstr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChannelScreen.this.channel.loadInstrument();
            }
        });
        this.btnEditInstr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getSamplerModel().editBackendInstrument(ChannelScreen.this.channel.getChannelId());
            }
        });
        this.btnEngine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ChannelScreen.this.btnEngine.getHeight() + 1;
                ChannelScreen.this.menuEngines.show(ChannelScreen.this.btnEngine, 0, n);
            }
        });
        this.addMouseListener(this.getHandler());
        this.addHierarchyListener(this.getHandler());
        ((MainFrame)CC.getMainFrame()).getGuiTimer().addActionListener(this.guiListener);
    }

    private void uninstallListeners() {
        ((MainFrame)CC.getMainFrame()).getGuiTimer().removeActionListener(this.guiListener);
    }

    protected void updateScreenInfo(SamplerChannel samplerChannel) {
        String string = this.btnInstr.getToolTipText();
        int n = samplerChannel.getInstrumentStatus();
        if (n >= 0 && n < 100) {
            this.btnInstr.setText(FantasiaI18n.i18n.getLabel("ChannelScreen.loadingInstrument", n));
            if (string != null) {
                this.btnInstr.setToolTipText(null);
            }
        } else if (n == -1) {
            this.btnInstr.setText(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
            if (string != null) {
                this.btnInstr.setToolTipText(null);
            }
        } else if (n < -1) {
            this.btnInstr.setText(FantasiaI18n.i18n.getLabel("ChannelScreen.errorLoadingInstrument"));
            if (string != null) {
                this.btnInstr.setToolTipText(null);
            }
        } else {
            if (samplerChannel.getInstrumentName() != null) {
                this.btnInstr.setText(samplerChannel.getInstrumentName());
            } else {
                this.btnInstr.setText(FantasiaI18n.i18n.getButtonLabel("ChannelScreen.btnInstr"));
            }
            this.btnInstr.setToolTipText(samplerChannel.getInstrumentName());
        }
        this.instrumentPane.update();
        if (samplerChannel.getEngine() != null) {
            string = samplerChannel.getEngine().getName();
            if (!(string = string + " engine").equals(this.btnEngine.getText())) {
                this.btnEngine.setText(string);
                this.btnEngine.setToolTipText(samplerChannel.getEngine().getDescription());
            }
        }
    }

    protected void updateVolumeInfo(int n) {
        this.volumePane.updateVolumeInfo(n);
    }

    protected void updateStreamCount(int n) {
        this.streamVoiceCountPane.updateStreamCount(n);
    }

    protected void updateVoiceCount(int n) {
        this.streamVoiceCountPane.updateVoiceCount(n);
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    extends MouseAdapter
    implements HierarchyListener {
        private EventHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (ChannelScreen.this.channel.getChannelInfo().getInstrumentStatus() != 100) {
                return;
            }
            if (!ChannelScreen.this.sbbEditInstr.isVisible()) {
                ChannelScreen.this.sbbEditInstr.setVisible(true);
                ChannelScreen.this.instrumentPane.update();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (ChannelScreen.this.getMousePosition(true) != null) {
                return;
            }
            if (ChannelScreen.this.sbbEditInstr.isVisible()) {
                ChannelScreen.this.sbbEditInstr.setVisible(false);
                ChannelScreen.this.instrumentPane.update();
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) == 4L) {
                if (ChannelScreen.this.getMousePosition() == null) {
                    this.mouseExited(null);
                } else {
                    this.mouseEntered(null);
                }
            }
        }
    }

    static class ScreenButtonBg
    extends PixmapPane {
        ScreenButtonBg(JButton jButton) {
            super(Res.gfxScreenBtnBg);
            this.setPixmapInsets(new Insets(4, 4, 4, 4));
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 7));
            this.add(jButton);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 13));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, 13);
        }
    }

    class InstrumentPane
    extends JPanel {
        private final JPanel leftPane = new JPanel();
        private final JPanel rightPane = new JPanel();

        InstrumentPane() {
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.leftPane);
            this.add(ChannelScreen.this.btnInstr);
            this.add(this.rightPane);
            this.add(ChannelScreen.this.sbbEditInstr);
            ChannelScreen.this.btnEditInstr.setToolTipText(FantasiaI18n.i18n.getLabel("ChannelScreen.btnEditInstr.tt"));
            ChannelScreen.this.sbbEditInstr.setVisible(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 6));
            this.update();
        }

        public void update() {
            int n;
            int n2;
            int n3 = ((ChannelScreen)ChannelScreen.this).btnInstr.getMinimumSize().width;
            int n4 = 0;
            if (ChannelScreen.this.sbbEditInstr.isVisible()) {
                n4 = ((ChannelScreen)ChannelScreen.this).sbbEditInstr.getPreferredSize().width;
            }
            if (n3 > (n2 = 254 - n4)) {
                n3 = n2;
            }
            int n5 = ((ChannelScreen)ChannelScreen.this).btnInstr.getPreferredSize().height;
            ChannelScreen.this.btnInstr.setPreferredSize(new Dimension(n3, n5));
            n5 = ((ChannelScreen)ChannelScreen.this).btnInstr.getMaximumSize().height;
            ChannelScreen.this.btnInstr.setMaximumSize(new Dimension(n3, n5));
            int n6 = n = (254 - ((ChannelScreen)ChannelScreen.this).btnInstr.getPreferredSize().width) / 2;
            if (ChannelScreen.this.sbbEditInstr.isVisible()) {
                n6 -= ((ChannelScreen)ChannelScreen.this).sbbEditInstr.getPreferredSize().width;
            }
            if (n < 0 || n6 < 0) {
                n6 = 0;
                n = 0;
            }
            Dimension dimension = new Dimension(n, 1);
            this.leftPane.setMinimumSize(dimension);
            this.leftPane.setPreferredSize(dimension);
            this.leftPane.setMaximumSize(dimension);
            dimension = new Dimension(n6, 1);
            this.rightPane.setMinimumSize(dimension);
            this.rightPane.setPreferredSize(dimension);
            this.rightPane.setMaximumSize(dimension);
            this.validate();
        }
    }
}

