/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.Serializable;

public class Size
implements Serializable {
    public static final long DEFAULT_LENGTH = 255L;
    public static final long LONG_LENGTH = 32600L;
    public static final long DEFAULT_LOB_LENGTH = 0x100000L;
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;
    private Integer precision;
    private Integer scale;
    private Long length;
    private Integer arrayLength;
    private LobMultiplier lobMultiplier;

    public Size() {
    }

    @Deprecated(forRemoval=true)
    public Size(Integer precision, Integer scale, Long length, LobMultiplier lobMultiplier) {
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.lobMultiplier = lobMultiplier;
    }

    @Deprecated(forRemoval=true)
    public Size(Integer precision, Integer scale, Integer length, LobMultiplier lobMultiplier) {
        this.precision = precision;
        this.scale = scale;
        this.length = length == null ? null : Long.valueOf(length.longValue());
        this.lobMultiplier = lobMultiplier;
    }

    public Size(Integer precision, Integer scale, Long length) {
        this(precision, scale, length, LobMultiplier.NONE);
    }

    public static Size nil() {
        return new Size();
    }

    public static Size precision(int precision) {
        return new Size((Integer)precision, (Integer)-1, -1L, null);
    }

    public static Size precision(int precision, int scale) {
        return new Size((Integer)precision, (Integer)scale, -1L, null);
    }

    public static Size length(long length) {
        return new Size((Integer)-1, (Integer)-1, length, null);
    }

    public static Size length(long length, LobMultiplier lobMultiplier) {
        return new Size((Integer)-1, (Integer)-1, length, lobMultiplier);
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Long getLength() {
        return this.length;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    @Deprecated(forRemoval=true)
    public LobMultiplier getLobMultiplier() {
        return this.lobMultiplier;
    }

    public void initialize(Size size) {
        this.precision = size.precision;
        this.scale = size.scale;
        this.length = size.length;
    }

    public Size setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public Size setScale(Integer scale) {
        this.scale = scale;
        return this;
    }

    public Size setLength(Long length) {
        this.length = length;
        return this;
    }

    public Size setArrayLength(Integer arrayLength) {
        this.arrayLength = arrayLength;
        return this;
    }

    @Deprecated(forRemoval=true)
    public Size setLobMultiplier(LobMultiplier lobMultiplier) {
        this.lobMultiplier = lobMultiplier;
        return this;
    }

    @Deprecated(forRemoval=true)
    public static enum LobMultiplier {
        NONE(1L),
        K(LobMultiplier.NONE.factor * 1024L),
        M(LobMultiplier.K.factor * 1024L),
        G(LobMultiplier.M.factor * 1024L);

        private final long factor;

        private LobMultiplier(long factor) {
            this.factor = factor;
        }

        public long getFactor() {
            return this.factor;
        }
    }
}

