/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.ModifyStringType;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.EnvVars;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class ModifyEnvironmentVariableAction
extends SystemInstallOrUninstallAction
implements AutoUninstallAction {
    private ModifyStringType type = ModifyStringType.SET;
    private String variableName;
    private String value;
    private boolean userSpecific = true;
    private boolean revertOnUninstallation = true;
    private boolean revertOnlyIfNotModified = false;
    private Properties persistentProperties = new Properties();
    private static final String PROP_VARIABLE_NAME = "variableName";
    private static final String PROP_VARIABLE_VALUE = "variableValue";
    private static final String PROP_USER_SPECIFIC = "userSpecific";
    private static final String PROP_TYPE = "type";
    private static final String PROP_ORIGINAL_VALUE = "originalValue";
    private static final String PROP_MODIFIED_VALUE = "modifiedValue";
    private static final String PROP_AUTO_UNINSTALL_TYPE = "autoUninstallType";
    private static final String AUTO_UNINSTALL_TYPE_NEVER = "never";
    private static final String AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED = "onlyIfNotModified";
    private static final String AUTO_UNINSTALL_TYPE_ALWAYS = "always";

    public ModifyStringType getType() {
        return this.replaceWithTextOverride(PROP_TYPE, this.type, ModifyStringType.class);
    }

    public void setType(ModifyStringType type) {
        this.type = type;
    }

    public String getVariableName() {
        return ModifyEnvironmentVariableAction.replaceVariables(ModifyEnvironmentVariableAction.replaceVariables(this.variableName));
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getValue() {
        return ModifyEnvironmentVariableAction.replaceVariables(ModifyEnvironmentVariableAction.replaceVariables(this.value));
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUserSpecific() {
        return this.replaceWithTextOverride(PROP_USER_SPECIFIC, this.userSpecific);
    }

    public void setUserSpecific(boolean userSpecific) {
        this.userSpecific = userSpecific;
    }

    public boolean isRevertOnUninstallation() {
        return this.replaceWithTextOverride("revertOnUninstallation", this.revertOnUninstallation);
    }

    public void setRevertOnUninstallation(boolean revertOnUninstallation) {
        this.revertOnUninstallation = revertOnUninstallation;
    }

    public boolean isRevertOnlyIfNotModified() {
        return this.replaceWithTextOverride("revertOnlyIfNotModified", this.revertOnlyIfNotModified);
    }

    public void setRevertOnlyIfNotModified(boolean revertOnlyIfNotModified) {
        this.revertOnlyIfNotModified = revertOnlyIfNotModified;
    }

    @Override
    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        try {
            String modifiedValue;
            ModifyStringType type;
            String autoUninstallType = AUTO_UNINSTALL_TYPE_NEVER;
            if (this.isRevertOnUninstallation()) {
                String originalValue = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific());
                if (originalValue != null) {
                    this.getPersistentProperties().setProperty(PROP_ORIGINAL_VALUE, originalValue);
                }
                autoUninstallType = this.isRevertOnlyIfNotModified() ? AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED : AUTO_UNINSTALL_TYPE_ALWAYS;
            }
            String usedValue = (type = this.getType()) == ModifyStringType.REMOVE ? null : this.getValue();
            List<InstallAction> rollbackActions = EnvVars.set(this.getVariableName(), usedValue, this.isUserSpecific(), type == ModifyStringType.APPEND, type == ModifyStringType.PREPEND);
            this.addRollbackActions(rollbackActions);
            if (rollbackActions.size() == 0) {
                autoUninstallType = AUTO_UNINSTALL_TYPE_NEVER;
            }
            if (!Objects.equals(autoUninstallType, AUTO_UNINSTALL_TYPE_NEVER) && (modifiedValue = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific())) != null) {
                this.getPersistentProperties().setProperty(PROP_MODIFIED_VALUE, modifiedValue);
            }
            this.getPersistentProperties().setProperty(PROP_VARIABLE_NAME, this.getVariableName());
            if (usedValue != null) {
                this.getPersistentProperties().setProperty(PROP_VARIABLE_VALUE, usedValue);
            }
            this.getPersistentProperties().setProperty(PROP_USER_SPECIFIC, String.valueOf(this.isUserSpecific()));
            this.getPersistentProperties().setProperty(PROP_TYPE, type.toString());
            this.getPersistentProperties().setProperty(PROP_AUTO_UNINSTALL_TYPE, autoUninstallType);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        if (Boolean.getBoolean("install4j.debugModifyEnvVar")) {
            Util.logInfo(this, this.getPersistentProperties().toString());
        }
        if (this.getPersistentProperties().size() == 0) {
            return this.execute(context);
        }
        try {
            String autoUninstallType = this.getPersistentProperties().getProperty(PROP_AUTO_UNINSTALL_TYPE);
            if (!Objects.equals(autoUninstallType, AUTO_UNINSTALL_TYPE_NEVER)) {
                String variableName = this.getPersistentProperties().getProperty(PROP_VARIABLE_NAME);
                boolean userSpecific = Boolean.parseBoolean(this.getPersistentProperties().getProperty(PROP_USER_SPECIFIC));
                String currentValue = EnvVars.getWinNT(variableName, userSpecific);
                String originalValue = this.getPersistentProperties().getProperty(PROP_ORIGINAL_VALUE);
                ModifyStringType type = ModifyStringType.getFromString(this.getPersistentProperties().getProperty(PROP_TYPE));
                if (currentValue != null) {
                    if (Objects.equals(autoUninstallType, AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED)) {
                        if (Objects.equals(currentValue, this.getPersistentProperties().getProperty(PROP_MODIFIED_VALUE))) {
                            EnvVars.setWinNT(variableName, originalValue, userSpecific);
                        }
                    } else if (type == ModifyStringType.SET || type == ModifyStringType.REMOVE || currentValue.equals(this.getPersistentProperties().getProperty(PROP_MODIFIED_VALUE))) {
                        EnvVars.setWinNT(variableName, originalValue, userSpecific);
                    } else {
                        int index;
                        String addedMainValue;
                        String addedValue = addedMainValue = this.getPersistentProperties().getProperty(PROP_VARIABLE_VALUE);
                        if (type == ModifyStringType.APPEND) {
                            if (originalValue != null && originalValue.length() > 0) {
                                addedValue = ";" + addedValue;
                            }
                            if ((index = currentValue.endsWith(addedValue) ? currentValue.length() - addedValue.length() : currentValue.lastIndexOf(addedValue + ";")) == -1) {
                                addedValue = addedMainValue;
                                index = currentValue.endsWith(addedValue) ? currentValue.length() - addedValue.length() : currentValue.lastIndexOf(addedValue + ";");
                            }
                        } else {
                            if (originalValue != null && originalValue.length() > 0) {
                                addedValue = addedValue + ";";
                            }
                            if ((index = currentValue.startsWith(addedValue) ? 0 : currentValue.indexOf(";" + addedValue) - 1) < 0) {
                                addedValue = addedMainValue;
                                index = currentValue.startsWith(addedValue) ? 0 : currentValue.indexOf(";" + addedValue) - 1;
                            }
                        }
                        if (index > -1) {
                            String newValue = currentValue.substring(0, index) + currentValue.substring(index + addedValue.length());
                            EnvVars.setWinNT(variableName, newValue, userSpecific);
                        }
                    }
                } else if (type == ModifyStringType.REMOVE) {
                    EnvVars.setWinNT(variableName, originalValue, userSpecific);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public Properties getPersistentProperties() {
        return this.replaceWithTextOverride("persistentProperties", this.persistentProperties, Properties.class);
    }

    @Override
    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }
}

