/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUCache;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

final class LRUStatementCache {
    private int cacheSize;
    private final LRUCache<OraclePreparedStatement> implicitCache = new LRUCache(true);
    private final LRUCache<OraclePreparedStatement> explicitCache = new LRUCache(false);
    private boolean implicitCacheEnabled = false;
    private boolean explicitCacheEnabled = false;
    static final String DMS_HIT_COUNT_NAME = "StatementCacheHit";
    static final String DMS_HIT_COUNT_DESCRIPTION = "Statement found in cache";
    static final String DMS_MISS_COUNT_NAME = "StatementCacheMiss";
    static final String DMS_MISS_COUNT_DESCRIPTION = "Statement not found in cache";
    DMSFactory.DMSEvent dmsStatementCacheHitCount = null;
    DMSFactory.DMSEvent dmsStatementCacheMissCount = null;

    LRUStatementCache(int size) throws SQLException {
        if (size < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        this.cacheSize = size;
        this.implicitCache.vacancy(size);
        this.explicitCache.vacancy(size);
    }

    protected void createDMSSensors(DMSFactory.DMSNoun parent) {
        this.dmsStatementCacheHitCount = DMSFactory.getInstance().createEvent(parent, DMS_HIT_COUNT_NAME, DMS_HIT_COUNT_DESCRIPTION);
        this.dmsStatementCacheMissCount = DMSFactory.getInstance().createEvent(parent, DMS_MISS_COUNT_NAME, DMS_MISS_COUNT_DESCRIPTION);
    }

    public void resize(int newSize) throws SQLException {
        if (newSize < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
        }
        while (this.implicitCache.size() > newSize) {
            this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
        }
        while (this.explicitCache.size() > newSize) {
            this.explicitCache.removeLeastRecent().exitExplicitCacheToClose();
        }
        this.cacheSize = newSize;
        this.implicitCache.vacancy(newSize);
        this.explicitCache.vacancy(newSize);
    }

    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        if (!cache) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = cache;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        return retValue;
    }

    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        if (!cache) {
            this.purgeExplicitCache();
        }
        this.explicitCacheEnabled = cache;
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
        return retValue;
    }

    void addToImplicitCache(OraclePreparedStatement stmt, String sql, int statementType, int scrollType) throws SQLException {
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
            return;
        }
        stmt.enterImplicitCache();
        this.implicitCache.add(stmt, statementType, scrollType, sql);
        while (this.implicitCache.size() > this.cacheSize) {
            this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
        }
    }

    void addToExplicitCache(OraclePreparedStatement stmt, String key) throws SQLException {
        if (!this.explicitCacheEnabled || this.cacheSize == 0 || stmt.cacheState == 2) {
            return;
        }
        stmt.enterExplicitCache();
        this.explicitCache.add(stmt, 0, 0, key);
        while (this.explicitCache.size() > this.cacheSize) {
            this.explicitCache.removeLeastRecent().exitExplicitCacheToClose();
        }
    }

    OracleStatement searchImplicitCache(String sql, int statementType, int scrollType, PhysicalConnection _conn) throws SQLException {
        if (!this.implicitCacheEnabled || this.cacheSize == 0) {
            return null;
        }
        OraclePreparedStatement stmt = this.implicitCache.removeMostRecent(statementType, scrollType, sql);
        if (stmt != null) {
            stmt.exitImplicitCacheToActive();
            this.dmsStatementCacheHitCount.occurred();
        } else {
            this.dmsStatementCacheMissCount.occurred();
        }
        return stmt;
    }

    OracleStatement searchExplicitCache(String key) throws SQLException {
        if (!this.explicitCacheEnabled || 0 == this.cacheSize) {
            return null;
        }
        OraclePreparedStatement stmt = this.explicitCache.removeMostRecent(0, 0, key);
        if (null != stmt) {
            stmt.exitExplicitCacheToActive();
            this.dmsStatementCacheHitCount.occurred();
        } else {
            this.dmsStatementCacheMissCount.occurred();
        }
        return stmt;
    }

    void purgeImplicitCache() throws SQLException {
        OraclePreparedStatement stmt = this.implicitCache.removeLeastRecent();
        while (null != stmt) {
            stmt.exitImplicitCacheToClose();
            stmt = this.implicitCache.removeLeastRecent();
        }
    }

    void purgeExplicitCache() throws SQLException {
        OraclePreparedStatement stmt = this.explicitCache.removeLeastRecent();
        while (null != stmt) {
            stmt.exitExplicitCacheToClose();
            stmt = this.explicitCache.removeLeastRecent();
        }
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void close() throws SQLException {
        this.purgeImplicitCache();
        this.implicitCache.close();
        this.purgeExplicitCache();
        this.explicitCache.close();
    }

    private OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    protected void clearCursorIds() {
        this.implicitCache.forEach(p -> p.clearCursorId());
        this.explicitCache.forEach(p -> p.clearCursorId());
    }

    public String toString() {
        return "implicitCache=" + this.implicitCache.toString() + ", explicitCache=" + this.explicitCache.toString();
    }
}

