/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.quantiles;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.quantiles.CompactDoublesSketch;
import com.yahoo.sketches.quantiles.DirectUpdateDoublesSketchR;
import com.yahoo.sketches.quantiles.DoublesSketchAccessor;
import com.yahoo.sketches.quantiles.DoublesUtil;
import com.yahoo.sketches.quantiles.PreambleUtil;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import com.yahoo.sketches.quantiles.Util;
import java.util.Arrays;

final class DirectCompactDoublesSketch
extends CompactDoublesSketch {
    private static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    private WritableMemory mem_;

    private DirectCompactDoublesSketch(int k) {
        super(k);
    }

    static DirectCompactDoublesSketch createFromUpdateSketch(UpdateDoublesSketch sketch, WritableMemory dstMem) {
        long memCap = dstMem.getCapacity();
        int k = sketch.getK();
        long n = sketch.getN();
        DirectCompactDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        dstMem.putLong(0L, 0L);
        PreambleUtil.insertPreLongs(dstMem, 2);
        PreambleUtil.insertSerVer(dstMem, 3);
        PreambleUtil.insertFamilyID(dstMem, Family.QUANTILES.getID());
        PreambleUtil.insertK(dstMem, k);
        int flags = 10;
        if (sketch.isEmpty()) {
            PreambleUtil.insertFlags(dstMem, 14);
        } else {
            PreambleUtil.insertFlags(dstMem, 10);
            PreambleUtil.insertN(dstMem, n);
            PreambleUtil.insertMinDouble(dstMem, sketch.getMinValue());
            PreambleUtil.insertMaxDouble(dstMem, sketch.getMaxValue());
            int bbCount = Util.computeBaseBufferItems(k, n);
            DoublesSketchAccessor inputAccessor = DoublesSketchAccessor.wrap(sketch);
            assert (bbCount == inputAccessor.numItems());
            long dstMemOffset = 32L;
            double[] bbArray = inputAccessor.getArray(0, bbCount);
            Arrays.sort(bbArray);
            dstMem.putDoubleArray(dstMemOffset, bbArray, 0, bbCount);
            dstMemOffset += (long)(bbCount << 3);
            int lvl = 0;
            for (long bitPattern = Util.computeBitPattern(k, n); bitPattern > 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    inputAccessor.setLevel(lvl);
                    dstMem.putDoubleArray(dstMemOffset, inputAccessor.getArray(0, k), 0, k);
                    dstMemOffset += (long)(k << 3);
                }
                ++lvl;
            }
        }
        DirectCompactDoublesSketch dcds = new DirectCompactDoublesSketch(k);
        dcds.mem_ = dstMem;
        return dcds;
    }

    static DirectCompactDoublesSketch wrapInstance(Memory srcMem) {
        long memCap = srcMem.getCapacity();
        int preLongs = PreambleUtil.extractPreLongs(srcMem);
        int serVer = PreambleUtil.extractSerVer(srcMem);
        int familyID = PreambleUtil.extractFamilyID(srcMem);
        int flags = PreambleUtil.extractFlags(srcMem);
        int k = PreambleUtil.extractK(srcMem);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcMem);
        DirectUpdateDoublesSketchR.checkPreLongs(preLongs);
        Util.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectCompactDoublesSketch.checkCompact(serVer, flags);
        Util.checkK(k);
        DirectCompactDoublesSketch.checkDirectMemCapacity(k, n, memCap);
        DirectUpdateDoublesSketchR.checkEmptyAndN(empty, n);
        DirectCompactDoublesSketch dds = new DirectCompactDoublesSketch(k);
        dds.mem_ = (WritableMemory)srcMem;
        return dds;
    }

    @Override
    public double getMaxValue() {
        return this.isEmpty() ? Double.NaN : this.mem_.getDouble(24L);
    }

    @Override
    public double getMinValue() {
        return this.isEmpty() ? Double.NaN : this.mem_.getDouble(16L);
    }

    @Override
    public long getN() {
        return this.mem_.getCapacity() < 32L ? 0L : this.mem_.getLong(8L);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.mem_.isSameResource((Object)that);
    }

    @Override
    int getBaseBufferCount() {
        return Util.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return ((int)this.mem_.getCapacity() - 32) / 8;
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = Util.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[itemCap];
        this.mem_.getDoubleArray(32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return Util.computeBitPattern(k, n);
    }

    @Override
    WritableMemory getMemory() {
        return this.mem_;
    }

    static void checkDirectMemCapacity(int k, long n, long memCapBytes) {
        int reqBufBytes = DirectCompactDoublesSketch.getCompactStorageBytes(k, n);
        if (memCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: Memory capacity too small: " + memCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        int compactFlagMask = 24;
        if (serVer != 2 && (flags & 4) == 0 && (flags & 0x18) != 24) {
            throw new SketchesArgumentException("Possible corruption: Must be v2, empty, or compact and ordered. Flags field: " + Integer.toBinaryString(flags) + ", SerVer: " + serVer);
        }
    }
}

