/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.options;

import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.core.options.UISupport;
import org.graalvm.visualvm.heapviewer.options.HeapViewerOptionsPanel;
import org.graalvm.visualvm.heapviewer.oql.CustomOQLQueries;
import org.graalvm.visualvm.heapviewer.oql.OQLQuery;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class HeapViewerOptionsCategory
extends OptionsPanelController {
    private static final HelpCtx HELP_CTX = null;
    public static final String OPTIONS_HANDLE = "HeapViewerOptions";
    private HeapViewerOptionsPanel settingsPanel;
    private JComponent settingsComponent;

    private HeapViewerOptionsPanel getPanel() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new HeapViewerOptionsPanel();
        }
        return this.settingsPanel;
    }

    public JComponent getComponent(Lookup lookup) {
        if (this.settingsComponent == null) {
            this.settingsComponent = UISupport.createScrollableContainer((JComponent)this.getPanel());
        }
        return this.settingsComponent;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public boolean isChanged() {
        if (this.settingsPanel == null) {
            return false;
        }
        List<OQLQuery> master = CustomOQLQueries.instance().list();
        List<OQLQuery> edited = this.getPanel().getQueries();
        if (master.size() != edited.size()) {
            return true;
        }
        for (int i = 0; i < master.size(); ++i) {
            if (HeapViewerOptionsCategory.sameQuery(master.get(i), edited.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void applyChanges() {
        if (this.settingsPanel == null) {
            return;
        }
        CustomOQLQueries.instance().set(this.getPanel().getQueries());
    }

    public void cancel() {
    }

    public void update() {
        new RequestProcessor("OQL Scripts Loader").post(new Runnable(){

            @Override
            public void run() {
                final List<OQLQuery> queries = CustomOQLQueries.instance().list();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HeapViewerOptionsCategory.this.getPanel().setQueries(queries);
                    }
                });
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    private static boolean sameQuery(OQLQuery query1, OQLQuery query2) {
        if (!Objects.equals(query1.getName(), query2.getName())) {
            return false;
        }
        return Objects.equals(query1.getDescription(), query2.getDescription());
    }
}

