# -*- coding: utf-8 -*-
# Copyright 2022 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the ios_snmp_server module
"""


class Snmp_serverArgs(object):  # pylint: disable=R0903
    """The arg spec for the ios_snmp_server module"""

    argument_spec = {
        "config": {
            "options": {
                "accounting": {
                    "options": {"command": {"type": "str"}},
                    "type": "dict",
                },
                "cache": {"type": "int"},
                "chassis_id": {"type": "str"},
                "communities": {
                    "elements": "dict",
                    "options": {
                        "acl_v4": {"type": "str"},
                        "acl_v6": {"type": "str"},
                        "name": {"type": "str"},
                        "ro": {"type": "bool"},
                        "rw": {"type": "bool"},
                        "view": {"type": "str"},
                    },
                    "type": "list",
                },
                "contact": {"type": "str"},
                "context": {"elements": "str", "type": "list"},
                "drop": {
                    "options": {
                        "unknown_user": {"type": "bool"},
                        "vrf_traffic": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "engine_id": {
                    "elements": "dict",
                    "options": {
                        "id": {"type": "str"},
                        "local": {"type": "bool"},
                        "remote": {
                            "options": {
                                "host": {"type": "str"},
                                "udp_port": {"type": "int"},
                                "vrf": {"type": "str"},
                            },
                            "type": "dict",
                        },
                    },
                    "type": "list",
                },
                "file_transfer": {
                    "options": {
                        "access_group": {"type": "str"},
                        "protocol": {"type": "list", "elements": "str"},
                    },
                    "type": "dict",
                },
                "groups": {
                    "elements": "dict",
                    "options": {
                        "context": {"type": "str"},
                        "match": {"choices": ["exact", "prefix"], "type": "str"},
                        "version_option": {
                            "choices": ["auth", "noauth", "priv"],
                            "type": "str",
                        },
                        "group": {"type": "str"},
                        "notify": {"type": "str"},
                        "read": {"type": "str"},
                        "version": {"choices": ["v1", "v3", "v2c"], "type": "str"},
                        "write": {"type": "str"},
                        "acl_v4": {"type": "str"},
                        "acl_v6": {"type": "str"},
                    },
                    "type": "list",
                },
                "hosts": {
                    "elements": "dict",
                    "options": {
                        "host": {"type": "str"},
                        "informs": {"type": "bool"},
                        "community_string": {"type": "str"},
                        "traps": {"type": "list", "elements": "str"},
                        "version": {"choices": ["1", "2c", "3"], "type": "str"},
                        "version_option": {
                            "choices": ["auth", "noauth", "priv"],
                            "type": "str",
                        },
                        "vrf": {"type": "str"},
                    },
                    "type": "list",
                },
                "if_index": {"type": "bool"},
                "inform": {
                    "options": {
                        "pending": {"type": "int"},
                        "retries": {"type": "int"},
                        "timeout": {"type": "int"},
                    },
                    "type": "dict",
                },
                "ip": {
                    "options": {
                        "dscp": {"type": "int"},
                        "precedence": {"type": "int"},
                    },
                    "type": "dict",
                },
                "location": {"type": "str"},
                "manager": {"type": "int"},
                "packet_size": {"type": "int"},
                "password_policy": {
                    "elements": "dict",
                    "no_log": False,
                    "options": {
                        "change": {"type": "int"},
                        "digits": {"type": "int"},
                        "lower_case": {"type": "int"},
                        "max_len": {"type": "int"},
                        "min_len": {"type": "int"},
                        "policy_name": {"type": "str"},
                        "special_char": {"type": "int"},
                        "upper_case": {"type": "int"},
                        "username": {"type": "str"},
                    },
                    "type": "list",
                },
                "queue_length": {"type": "int"},
                "source_interface": {"type": "str"},
                "system_shutdown": {"type": "bool"},
                "trap_source": {"type": "str"},
                "trap_timeout": {"type": "int"},
                "traps": {
                    "options": {
                        "aaa_server": {"type": "bool"},
                        "auth_framework": {
                            "options": {
                                "sec_violation": {"type": "bool"},
                                "enable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "bfd": {
                            "options": {
                                "enable": {"type": "bool"},
                                "session_down": {"type": "bool"},
                                "session_up": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "bgp": {
                            "options": {
                                "cbgp2": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "state_changes": {
                                    "options": {
                                        "all": {"type": "bool"},
                                        "backward_trans": {"type": "bool"},
                                        "limited": {"type": "bool"},
                                        "enable": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "threshold": {
                                    "options": {"prefix": {"type": "bool"}},
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "bridge": {
                            "options": {
                                "newroot": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "topologychange": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "bulkstat": {
                            "options": {
                                "enable": {"type": "bool"},
                                "collection": {"type": "bool"},
                                "transfer": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "call_home": {
                            "options": {
                                "enable": {"type": "bool"},
                                "message_send_fail": {"type": "bool"},
                                "server_fail": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "casa": {"type": "bool"},
                        "cef": {
                            "options": {
                                "inconsistency": {"type": "bool"},
                                "peer_fib_state_change": {"type": "bool"},
                                "peer_state_change": {"type": "bool"},
                                "resource_failure": {"type": "bool"},
                                "enable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "cnpd": {"type": "bool"},
                        "config": {"type": "bool"},
                        "config_copy": {"type": "bool"},
                        "config_ctid": {"type": "bool"},
                        "cpu": {
                            "options": {
                                "enable": {"type": "bool"},
                                "threshold": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "dhcp": {"type": "bool"},
                        "dlsw": {
                            "options": {
                                "circuit": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "tconn": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "eigrp": {"type": "bool"},
                        "entity": {"type": "bool"},
                        "entity_diag": {
                            "options": {
                                "boot_up_fail": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "hm_test_recover": {"type": "bool"},
                                "hm_thresh_reached": {"type": "bool"},
                                "scheduled_test_fail": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "entity_perf": {
                            "options": {
                                "enable": {"type": "bool"},
                                "throughput_notif": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "entity_state": {"type": "bool"},
                        "energywise": {"type": "bool"},
                        "envmon": {
                            "options": {
                                "enable": {"type": "bool"},
                                "fan": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "shutdown": {"type": "bool"},
                                        "status": {"type": "bool"},
                                        "supply": {"type": "bool"},
                                        "temperature": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "fan_enable": {"type": "bool"},
                                "shutdown": {"type": "bool"},
                                "status": {"type": "bool"},
                                "supply": {"type": "bool"},
                                "temperature": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "errdisable": {"type": "bool"},
                        "ethernet": {
                            "options": {
                                "cfm": {
                                    "options": {
                                        "alarm": {"type": "bool"},
                                        "cc": {
                                            "type": "dict",
                                            "options": {
                                                "config": {"type": "bool"},
                                                "cross_connect": {"type": "bool"},
                                                "loop": {"type": "bool"},
                                                "mep_down": {"type": "bool"},
                                                "mep_up": {"type": "bool"},
                                            },
                                        },
                                        "crosscheck": {
                                            "type": "dict",
                                            "options": {
                                                "mep_missing": {"type": "bool"},
                                                "mep_unknown": {"type": "bool"},
                                                "service_up": {"type": "bool"},
                                            },
                                        },
                                    },
                                    "type": "dict",
                                },
                                "evc": {
                                    "options": {
                                        "create": {"type": "bool"},
                                        "delete": {"type": "bool"},
                                        "status": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "ether_oam": {"type": "bool"},
                        "event_manager": {"type": "bool"},
                        "flash": {
                            "options": {
                                "enable": {"type": "bool"},
                                "insertion": {"type": "bool"},
                                "lowspace": {"type": "bool"},
                                "removal": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "flex_links": {
                            "options": {
                                "enable": {"type": "bool"},
                                "status": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "firewall": {
                            "options": {
                                "enable": {"type": "bool"},
                                "serverstatus": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "flowmon": {"type": "bool"},
                        "frame_relay": {
                            "options": {
                                "enable": {"type": "bool"},
                                "subif": {
                                    "options": {
                                        "count": {"type": "int"},
                                        "interval": {"type": "int"},
                                        "enable": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "fru_ctrl": {"type": "bool"},
                        "hsrp": {"type": "bool"},
                        "ike": {
                            "options": {
                                "policy": {
                                    "options": {
                                        "add": {"type": "bool"},
                                        "delete": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "tunnel": {
                                    "options": {
                                        "start": {"type": "bool"},
                                        "stop": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "ipmulticast": {"type": "bool"},
                        "ipsec": {
                            "options": {
                                "cryptomap": {
                                    "options": {
                                        "add": {"type": "bool"},
                                        "attach": {"type": "bool"},
                                        "delete": {"type": "bool"},
                                        "detach": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "too_many_sas": {"type": "bool"},
                                "tunnel": {
                                    "options": {
                                        "start": {"type": "bool"},
                                        "stop": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "ipsla": {"type": "bool"},
                        "isis": {"type": "bool"},
                        "l2tc": {
                            "options": {
                                "enable": {"type": "bool"},
                                "sys_threshold": {"type": "bool"},
                                "threshold": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "l2tun": {
                            "options": {
                                "pseudowire_status": {"type": "bool"},
                                "session": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "license": {"type": "bool"},
                        "lisp": {"type": "bool"},
                        "local_auth": {"type": "bool"},
                        "mac_notification": {
                            "options": {
                                "enable": {"type": "bool"},
                                "change": {"type": "bool"},
                                "move": {"type": "bool"},
                                "threshold": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "memory": {
                            "options": {
                                "enable": {"type": "bool"},
                                "bufferpeak": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "mpls": {
                            "options": {
                                "fast_reroute": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "protected": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "ldp": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "pv_limit": {"type": "bool"},
                                        "session_down": {"type": "bool"},
                                        "session_up": {"type": "bool"},
                                        "threshold": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "rfc": {
                                    "options": {
                                        "ldp": {
                                            "options": {
                                                "enable": {"type": "bool"},
                                                "pv_limit": {"type": "bool"},
                                                "session_down": {"type": "bool"},
                                                "session_up": {"type": "bool"},
                                                "threshold": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "traffic_eng": {
                                            "options": {
                                                "enable": {"type": "bool"},
                                                "down": {"type": "bool"},
                                                "reoptimized": {"type": "bool"},
                                                "reroute": {"type": "bool"},
                                                "up": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                        "vpn": {
                                            "options": {
                                                "enable": {"type": "bool"},
                                                "illegal_label": {"type": "bool"},
                                                "max_thresh_cleared": {
                                                    "type": "bool",
                                                },
                                                "max_threshold": {"type": "bool"},
                                                "mid_threshold": {"type": "bool"},
                                                "vrf_down": {"type": "bool"},
                                                "vrf_up": {"type": "bool"},
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "traffic_eng": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "down": {"type": "bool"},
                                        "reroute": {"type": "bool"},
                                        "up": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "vpn": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "illegal_label": {"type": "bool"},
                                        "max_thresh_cleared": {"type": "bool"},
                                        "max_threshold": {"type": "bool"},
                                        "mid_threshold": {"type": "bool"},
                                        "vrf_down": {"type": "bool"},
                                        "vrf_up": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "mpls_vpn": {"type": "bool"},
                        "msdp": {"type": "bool"},
                        "mvpn": {"type": "bool"},
                        "nhrp": {
                            "options": {
                                "enable": {"type": "bool"},
                                "nhc": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "down": {"type": "bool"},
                                        "up": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "nhp": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "down": {"type": "bool"},
                                        "up": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "nhs": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "down": {"type": "bool"},
                                        "up": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "quota_exceeded": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "ospf": {
                            "options": {
                                "cisco_specific": {
                                    "options": {
                                        "error": {"type": "bool"},
                                        "lsa": {"type": "bool"},
                                        "retransmit": {"type": "bool"},
                                        "state_change": {
                                            "options": {
                                                "nssa_trans_change": {
                                                    "type": "bool",
                                                },
                                                "shamlink": {
                                                    "options": {
                                                        "interface": {
                                                            "type": "bool",
                                                        },
                                                        "neighbor": {
                                                            "type": "bool",
                                                        },
                                                    },
                                                    "type": "dict",
                                                },
                                            },
                                            "type": "dict",
                                        },
                                    },
                                    "type": "dict",
                                },
                                "error": {"type": "bool"},
                                "retransmit": {"type": "bool"},
                                "lsa": {"type": "bool"},
                                "state_change": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "ospfv3": {
                            "options": {
                                "errors": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "bad_packet": {"type": "bool"},
                                        "config_error": {"type": "bool"},
                                        "virt_bad_packet": {"type": "bool"},
                                        "virt_config_error": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                                "rate_limit": {"type": "int"},
                                "state_change": {
                                    "options": {
                                        "enable": {"type": "bool"},
                                        "if_state_change": {"type": "bool"},
                                        "neighbor_restart_helper_status_change": {
                                            "type": "bool",
                                        },
                                        "neighbor_state_change": {"type": "bool"},
                                        "nssa_translator_status_change": {
                                            "type": "bool",
                                        },
                                        "restart_status_change": {"type": "bool"},
                                        "virtif_state_change": {"type": "bool"},
                                        "vn_restart_helper_status_change": {
                                            "type": "bool",
                                        },
                                        "vn_state_change": {"type": "bool"},
                                    },
                                    "type": "dict",
                                },
                            },
                            "type": "dict",
                        },
                        "pim": {
                            "options": {
                                "invalid_pim_message": {"type": "bool"},
                                "neighbor_change": {"type": "bool"},
                                "rp_mapping_change": {"type": "bool"},
                                "enable": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "pki": {"type": "bool"},
                        "port_security": {"type": "bool"},
                        "power_ethernet": {
                            "options": {
                                "enable": {"type": "bool"},
                                "group": {
                                    "options": {
                                        "slot_id": {"type": "int"},
                                        "threshold": {"type": "int"},
                                    },
                                    "elements": "dict",
                                    "type": "list",
                                },
                                "police": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "pw_vc": {"type": "bool"},
                        "rep": {"type": "bool"},
                        "rsvp": {"type": "bool"},
                        "rf": {"type": "bool"},
                        "smart_license": {
                            "options": {
                                "enable": {"type": "bool"},
                                "entitlement": {"type": "bool"},
                                "global": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "snmp": {
                            "options": {
                                "authentication": {"type": "bool"},
                                "coldstart": {"type": "bool"},
                                "linkdown": {"type": "bool"},
                                "linkup": {"type": "bool"},
                                "warmstart": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "stackwise": {"type": "bool"},
                        "stpx": {
                            "options": {
                                "enable": {"type": "bool"},
                                "inconsistency": {"type": "bool"},
                                "loop_inconsistency": {"type": "bool"},
                                "root_inconsistency": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "syslog": {"type": "bool"},
                        "transceiver_all": {"type": "bool"},
                        "trustsec": {
                            "options": {
                                "authz_file_error": {"type": "bool"},
                                "cache_file_error": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "keystore_file_error": {"type": "bool"},
                                "keystore_sync_fail": {"type": "bool"},
                                "random_number_fail": {"type": "bool"},
                                "src_entropy_fail": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "trustsec_interface": {
                            "options": {
                                "enable": {"type": "bool"},
                                "authc_fail": {"type": "bool"},
                                "authz_fail": {"type": "bool"},
                                "sap_fail": {"type": "bool"},
                                "supplicant_fail": {"type": "bool"},
                                "unauthorized": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "trustsec_policy": {
                            "options": {
                                "enable": {"type": "bool"},
                                "authz_sgacl_fail": {"type": "bool"},
                                "peer_policy_updated": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "trustsec_server": {
                            "options": {
                                "enable": {"type": "bool"},
                                "provision_secret": {"type": "bool"},
                                "radius_server": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "trustsec_sxp": {
                            "options": {
                                "enable": {"type": "bool"},
                                "binding_conflict": {"type": "bool"},
                                "binding_err": {"type": "bool"},
                                "binding_expn_fail": {"type": "bool"},
                                "conn_config_err": {"type": "bool"},
                                "conn_down": {"type": "bool"},
                                "conn_srcaddr_err": {"type": "bool"},
                                "conn_up": {"type": "bool"},
                                "msg_parse_err": {"type": "bool"},
                                "oper_nodeid_change": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "tty": {"type": "bool"},
                        "udld": {
                            "options": {
                                "enable": {"type": "bool"},
                                "link_fail_rpt": {"type": "bool"},
                                "status_change": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "vlan_membership": {"type": "bool"},
                        "vlancreate": {"type": "bool"},
                        "vlandelete": {"type": "bool"},
                        "vrfmib": {
                            "options": {
                                "vrf_up": {"type": "bool"},
                                "vrf_down": {"type": "bool"},
                                "vnet_trunk_up": {"type": "bool"},
                                "vnet_trunk_down": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "vrrp": {"type": "bool"},
                        "vswitch": {
                            "options": {
                                "dual_active": {"type": "bool"},
                                "enable": {"type": "bool"},
                                "vsl": {"type": "bool"},
                            },
                            "type": "dict",
                        },
                        "vtp": {"type": "bool"},
                    },
                    "type": "dict",
                },
                "users": {
                    "elements": "dict",
                    "options": {
                        "acl_v6": {"type": "str"},
                        "acl_v4": {"type": "str"},
                        "authentication": {
                            "no_log": False,
                            "type": "dict",
                            "options": {
                                "algorithm": {
                                    "type": "str",
                                    "choices": ["md5", "sha"],
                                },
                                "password": {
                                    "type": "str",
                                    "no_log": True,
                                },
                            },
                        },
                        "encryption": {
                            "no_log": False,
                            "type": "dict",
                            "options": {
                                "priv": {
                                    "type": "str",
                                    "choices": ["3des", "aes", "des"],
                                },
                                "priv_option": {"type": "str"},
                                "password": {
                                    "type": "str",
                                    "no_log": True,
                                },
                            },
                        },
                        "group": {"type": "str"},
                        "remote": {"type": "str"},
                        "udp_port": {"type": "int"},
                        "username": {"type": "str"},
                        "version": {"choices": ["v1", "v2c", "v3"], "type": "str"},
                        "version_option": {
                            "choices": ["encrypted"],
                            "type": "str",
                        },
                        "vrf": {"type": "str"},
                    },
                    "type": "list",
                },
                "views": {
                    "elements": "dict",
                    "options": {
                        "excluded": {"type": "bool"},
                        "family_name": {"type": "str"},
                        "included": {"type": "bool"},
                        "name": {"type": "str"},
                    },
                    "type": "list",
                },
            },
            "type": "dict",
        },
        "running_config": {"type": "str"},
        "state": {
            "choices": [
                "merged",
                "replaced",
                "overridden",
                "deleted",
                "parsed",
                "gathered",
                "rendered",
            ],
            "default": "merged",
            "type": "str",
        },
    }  # pylint: disable=C0301
