﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticmapreduce/EMR_EXPORTS.h>
#include <aws/elasticmapreduce/model/EbsVolume.h>
#include <aws/elasticmapreduce/model/InstanceStatus.h>
#include <aws/elasticmapreduce/model/MarketType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EMR {
namespace Model {

/**
 * <p>Represents an Amazon EC2 instance provisioned as part of
 * cluster.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticmapreduce-2009-03-31/Instance">AWS
 * API Reference</a></p>
 */
class Instance {
 public:
  AWS_EMR_API Instance() = default;
  AWS_EMR_API Instance(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API Instance& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EMR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique identifier for the instance in Amazon EMR.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  Instance& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the instance in Amazon EC2.</p>
   */
  inline const Aws::String& GetEc2InstanceId() const { return m_ec2InstanceId; }
  inline bool Ec2InstanceIdHasBeenSet() const { return m_ec2InstanceIdHasBeenSet; }
  template <typename Ec2InstanceIdT = Aws::String>
  void SetEc2InstanceId(Ec2InstanceIdT&& value) {
    m_ec2InstanceIdHasBeenSet = true;
    m_ec2InstanceId = std::forward<Ec2InstanceIdT>(value);
  }
  template <typename Ec2InstanceIdT = Aws::String>
  Instance& WithEc2InstanceId(Ec2InstanceIdT&& value) {
    SetEc2InstanceId(std::forward<Ec2InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The public DNS name of the instance.</p>
   */
  inline const Aws::String& GetPublicDnsName() const { return m_publicDnsName; }
  inline bool PublicDnsNameHasBeenSet() const { return m_publicDnsNameHasBeenSet; }
  template <typename PublicDnsNameT = Aws::String>
  void SetPublicDnsName(PublicDnsNameT&& value) {
    m_publicDnsNameHasBeenSet = true;
    m_publicDnsName = std::forward<PublicDnsNameT>(value);
  }
  template <typename PublicDnsNameT = Aws::String>
  Instance& WithPublicDnsName(PublicDnsNameT&& value) {
    SetPublicDnsName(std::forward<PublicDnsNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The public IP address of the instance.</p>
   */
  inline const Aws::String& GetPublicIpAddress() const { return m_publicIpAddress; }
  inline bool PublicIpAddressHasBeenSet() const { return m_publicIpAddressHasBeenSet; }
  template <typename PublicIpAddressT = Aws::String>
  void SetPublicIpAddress(PublicIpAddressT&& value) {
    m_publicIpAddressHasBeenSet = true;
    m_publicIpAddress = std::forward<PublicIpAddressT>(value);
  }
  template <typename PublicIpAddressT = Aws::String>
  Instance& WithPublicIpAddress(PublicIpAddressT&& value) {
    SetPublicIpAddress(std::forward<PublicIpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The private DNS name of the instance.</p>
   */
  inline const Aws::String& GetPrivateDnsName() const { return m_privateDnsName; }
  inline bool PrivateDnsNameHasBeenSet() const { return m_privateDnsNameHasBeenSet; }
  template <typename PrivateDnsNameT = Aws::String>
  void SetPrivateDnsName(PrivateDnsNameT&& value) {
    m_privateDnsNameHasBeenSet = true;
    m_privateDnsName = std::forward<PrivateDnsNameT>(value);
  }
  template <typename PrivateDnsNameT = Aws::String>
  Instance& WithPrivateDnsName(PrivateDnsNameT&& value) {
    SetPrivateDnsName(std::forward<PrivateDnsNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The private IP address of the instance.</p>
   */
  inline const Aws::String& GetPrivateIpAddress() const { return m_privateIpAddress; }
  inline bool PrivateIpAddressHasBeenSet() const { return m_privateIpAddressHasBeenSet; }
  template <typename PrivateIpAddressT = Aws::String>
  void SetPrivateIpAddress(PrivateIpAddressT&& value) {
    m_privateIpAddressHasBeenSet = true;
    m_privateIpAddress = std::forward<PrivateIpAddressT>(value);
  }
  template <typename PrivateIpAddressT = Aws::String>
  Instance& WithPrivateIpAddress(PrivateIpAddressT&& value) {
    SetPrivateIpAddress(std::forward<PrivateIpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current status of the instance.</p>
   */
  inline const InstanceStatus& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = InstanceStatus>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = InstanceStatus>
  Instance& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the instance group to which this instance belongs.</p>
   */
  inline const Aws::String& GetInstanceGroupId() const { return m_instanceGroupId; }
  inline bool InstanceGroupIdHasBeenSet() const { return m_instanceGroupIdHasBeenSet; }
  template <typename InstanceGroupIdT = Aws::String>
  void SetInstanceGroupId(InstanceGroupIdT&& value) {
    m_instanceGroupIdHasBeenSet = true;
    m_instanceGroupId = std::forward<InstanceGroupIdT>(value);
  }
  template <typename InstanceGroupIdT = Aws::String>
  Instance& WithInstanceGroupId(InstanceGroupIdT&& value) {
    SetInstanceGroupId(std::forward<InstanceGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the instance fleet to which an Amazon EC2 instance
   * belongs.</p>
   */
  inline const Aws::String& GetInstanceFleetId() const { return m_instanceFleetId; }
  inline bool InstanceFleetIdHasBeenSet() const { return m_instanceFleetIdHasBeenSet; }
  template <typename InstanceFleetIdT = Aws::String>
  void SetInstanceFleetId(InstanceFleetIdT&& value) {
    m_instanceFleetIdHasBeenSet = true;
    m_instanceFleetId = std::forward<InstanceFleetIdT>(value);
  }
  template <typename InstanceFleetIdT = Aws::String>
  Instance& WithInstanceFleetId(InstanceFleetIdT&& value) {
    SetInstanceFleetId(std::forward<InstanceFleetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The instance purchasing option. Valid values are <code>ON_DEMAND</code> or
   * <code>SPOT</code>. </p>
   */
  inline MarketType GetMarket() const { return m_market; }
  inline bool MarketHasBeenSet() const { return m_marketHasBeenSet; }
  inline void SetMarket(MarketType value) {
    m_marketHasBeenSet = true;
    m_market = value;
  }
  inline Instance& WithMarket(MarketType value) {
    SetMarket(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon EC2 instance type, for example <code>m3.xlarge</code>.</p>
   */
  inline const Aws::String& GetInstanceType() const { return m_instanceType; }
  inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
  template <typename InstanceTypeT = Aws::String>
  void SetInstanceType(InstanceTypeT&& value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = std::forward<InstanceTypeT>(value);
  }
  template <typename InstanceTypeT = Aws::String>
  Instance& WithInstanceType(InstanceTypeT&& value) {
    SetInstanceType(std::forward<InstanceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of Amazon EBS volumes that are attached to this instance.</p>
   */
  inline const Aws::Vector<EbsVolume>& GetEbsVolumes() const { return m_ebsVolumes; }
  inline bool EbsVolumesHasBeenSet() const { return m_ebsVolumesHasBeenSet; }
  template <typename EbsVolumesT = Aws::Vector<EbsVolume>>
  void SetEbsVolumes(EbsVolumesT&& value) {
    m_ebsVolumesHasBeenSet = true;
    m_ebsVolumes = std::forward<EbsVolumesT>(value);
  }
  template <typename EbsVolumesT = Aws::Vector<EbsVolume>>
  Instance& WithEbsVolumes(EbsVolumesT&& value) {
    SetEbsVolumes(std::forward<EbsVolumesT>(value));
    return *this;
  }
  template <typename EbsVolumesT = EbsVolume>
  Instance& AddEbsVolumes(EbsVolumesT&& value) {
    m_ebsVolumesHasBeenSet = true;
    m_ebsVolumes.emplace_back(std::forward<EbsVolumesT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_ec2InstanceId;

  Aws::String m_publicDnsName;

  Aws::String m_publicIpAddress;

  Aws::String m_privateDnsName;

  Aws::String m_privateIpAddress;

  InstanceStatus m_status;

  Aws::String m_instanceGroupId;

  Aws::String m_instanceFleetId;

  MarketType m_market{MarketType::NOT_SET};

  Aws::String m_instanceType;

  Aws::Vector<EbsVolume> m_ebsVolumes;
  bool m_idHasBeenSet = false;
  bool m_ec2InstanceIdHasBeenSet = false;
  bool m_publicDnsNameHasBeenSet = false;
  bool m_publicIpAddressHasBeenSet = false;
  bool m_privateDnsNameHasBeenSet = false;
  bool m_privateIpAddressHasBeenSet = false;
  bool m_statusHasBeenSet = false;
  bool m_instanceGroupIdHasBeenSet = false;
  bool m_instanceFleetIdHasBeenSet = false;
  bool m_marketHasBeenSet = false;
  bool m_instanceTypeHasBeenSet = false;
  bool m_ebsVolumesHasBeenSet = false;
};

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
