/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.GroupRequest;

public class SnapToGeometry
extends SnapToHelper {
    public static final String PROPERTY_SNAP_ENABLED = "SnapToGeometry.isEnabled";
    public static final String KEY_NORTH_ANCHOR = "SnapToGeometry.NorthAnchor";
    public static final String KEY_SOUTH_ANCHOR = "SnapToGeometry.SouthAnchor";
    public static final String KEY_WEST_ANCHOR = "SnapToGeometry.WestAnchor";
    public static final String KEY_EAST_ANCHOR = "SnapToGeometry.EastAnchor";
    protected static final double THRESHOLD = 5.0001;
    private double threshold = 5.0001;
    boolean cachedCloneBool;
    protected Entry[] rows;
    protected Entry[] cols;
    protected GraphicalEditPart container;

    public SnapToGeometry(GraphicalEditPart container) {
        this.container = container;
    }

    protected double getThreshold() {
        return this.threshold;
    }

    protected void setThreshold(double newThreshold) {
        this.threshold = newThreshold;
    }

    protected List<? extends GraphicalEditPart> generateSnapPartsList(List<? extends EditPart> exclusions) {
        ArrayList<? extends GraphicalEditPart> children = new ArrayList<GraphicalEditPart>(this.container.getChildren());
        children.removeAll(exclusions);
        return children.stream().filter(child -> child.getFigure().isVisible()).toList();
    }

    protected double getCorrectionFor(Entry[] entries, Map extendedData, boolean vert, double near, double far) {
        double result;
        double total = near + (far -= 1.0);
        if ((int)(near - far) % 2 != 0) {
            total -= 1.0;
        }
        if ((result = this.getCorrectionFor(entries, extendedData, vert, total / 2.0, 0)) == this.getThreshold()) {
            result = this.getCorrectionFor(entries, extendedData, vert, near, -1);
        }
        if (result == this.getThreshold()) {
            result = this.getCorrectionFor(entries, extendedData, vert, far, 1);
        }
        return result;
    }

    protected double getCorrectionFor(Entry[] entries, Map extendedData, boolean vert, double value, int side) {
        double resultMag = this.getThreshold();
        double result = this.getThreshold();
        String property = side == -1 ? (vert ? KEY_WEST_ANCHOR : KEY_NORTH_ANCHOR) : (vert ? KEY_EAST_ANCHOR : KEY_SOUTH_ANCHOR);
        Entry[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            double magnitude;
            Entry entry = entryArray[n2];
            if (entry.type == -1 && side != 0) {
                magnitude = Math.abs(value - (double)entry.location);
                if (magnitude < resultMag) {
                    resultMag = magnitude;
                    result = (double)entry.location - value;
                    extendedData.put(property, entry.location);
                }
            } else if (entry.type == 0 && side == 0) {
                magnitude = Math.abs(value - (double)entry.location);
                if (magnitude < resultMag) {
                    resultMag = magnitude;
                    result = (double)entry.location - value;
                    extendedData.put(property, entry.location);
                }
            } else if (entry.type == 1 && side != 0 && (magnitude = Math.abs(value - (double)entry.location)) < resultMag) {
                resultMag = magnitude;
                result = (double)entry.location - value;
                extendedData.put(property, entry.location);
            }
            ++n2;
        }
        return result;
    }

    protected Rectangle getFigureBounds(GraphicalEditPart part) {
        Rectangle rectangle;
        IFigure fig = part.getFigure();
        if (fig instanceof HandleBounds) {
            HandleBounds hb = (HandleBounds)fig;
            rectangle = hb.getHandleBounds();
        } else {
            rectangle = fig.getBounds();
        }
        return rectangle;
    }

    protected void populateRowsAndCols(List<? extends GraphicalEditPart> parts) {
        this.rows = new Entry[parts.size() * 3];
        this.cols = new Entry[parts.size() * 3];
        int i = 0;
        while (i < parts.size()) {
            GraphicalEditPart child = parts.get(i);
            Rectangle bounds = this.getFigureBounds(child);
            this.cols[i * 3] = new Entry(-1, bounds.x);
            this.rows[i * 3] = new Entry(-1, bounds.y);
            this.cols[i * 3 + 1] = new Entry(0, bounds.x + (bounds.width - 1) / 2);
            this.rows[i * 3 + 1] = new Entry(0, bounds.y + (bounds.height - 1) / 2);
            this.cols[i * 3 + 2] = new Entry(1, bounds.right() - 1);
            this.rows[i * 3 + 2] = new Entry(1, bounds.bottom() - 1);
            ++i;
        }
    }

    @Override
    public int snapRectangle(Request request, int snapOrientation, PrecisionRectangle baseRect, PrecisionRectangle result) {
        double topCorrection;
        double bottom;
        double leftCorrection;
        double rightCorrection;
        double ycorrect;
        double xcorrect;
        baseRect = baseRect.getPreciseCopy();
        this.makeRelative(this.container.getContentPane(), (Translatable)baseRect);
        PrecisionRectangle correction = new PrecisionRectangle();
        this.makeRelative(this.container.getContentPane(), (Translatable)correction);
        boolean isClone = request.getType().equals("clone");
        if (this.rows == null || this.cols == null || isClone != this.cachedCloneBool) {
            this.cachedCloneBool = isClone;
            List<Object> exclusionSet = Collections.emptyList();
            if (!isClone && request instanceof GroupRequest) {
                GroupRequest groupRequest = (GroupRequest)request;
                exclusionSet = groupRequest.getEditParts();
            }
            this.populateRowsAndCols(this.generateSnapPartsList(exclusionSet));
        }
        if ((snapOrientation & 0x40) != 0 && (xcorrect = this.getCorrectionFor(this.cols, request.getExtendedData(), true, baseRect.preciseX(), baseRect.preciseRight())) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFBF;
            correction.setPreciseX(correction.preciseX() + xcorrect);
        }
        if ((snapOrientation & 0x80) != 0 && (ycorrect = this.getCorrectionFor(this.rows, request.getExtendedData(), false, baseRect.preciseY(), baseRect.preciseBottom())) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFF7F;
            correction.setPreciseY(correction.preciseY() + ycorrect);
        }
        if ((snapOrientation & 0x10) != 0 && (rightCorrection = this.getCorrectionFor(this.cols, request.getExtendedData(), true, baseRect.preciseRight() - 1.0, 1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFEF;
            correction.setPreciseWidth(correction.preciseWidth() + rightCorrection);
        }
        if ((snapOrientation & 8) != 0 && (leftCorrection = this.getCorrectionFor(this.cols, request.getExtendedData(), true, baseRect.preciseX(), -1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFF7;
            correction.setPreciseWidth(correction.preciseWidth() - leftCorrection);
            correction.setPreciseX(correction.preciseX() + leftCorrection);
        }
        if ((snapOrientation & 4) != 0 && (bottom = this.getCorrectionFor(this.rows, request.getExtendedData(), false, baseRect.preciseBottom() - 1.0, 1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFFB;
            correction.setPreciseHeight(correction.preciseHeight() + bottom);
        }
        if ((snapOrientation & 1) != 0 && (topCorrection = this.getCorrectionFor(this.rows, request.getExtendedData(), false, baseRect.preciseY(), -1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFFE;
            correction.setPreciseHeight(correction.preciseHeight() - topCorrection);
            correction.setPreciseY(correction.preciseY() + topCorrection);
        }
        this.makeAbsolute(this.container.getContentPane(), (Translatable)correction);
        result.setPreciseX(result.preciseX() + correction.preciseX());
        result.setPreciseY(result.preciseY() + correction.preciseY());
        result.setPreciseWidth(result.preciseWidth() + correction.preciseWidth());
        result.setPreciseHeight(result.preciseHeight() + correction.preciseHeight());
        return snapOrientation;
    }

    protected static class Entry {
        final int type;
        final int location;

        protected Entry(int type, int location) {
            if (type < -1 || type > 1) {
                throw new IllegalArgumentException("Unrecognized snap type");
            }
            this.type = type;
            this.location = location;
        }

        public int getLocation() {
            return this.location;
        }

        public int getType() {
            return this.type;
        }
    }
}

