# F:=Rationals();
local result, l;
result:= rec();
result.comment:=
"A6 as 9 x 9 matrices over Z.\n\
Absolutely irreducible representation.\n\
Schur Index 1.\n\
\n\
SEED:\n\
Nonzero v fixed by <x,y*x*y*x*y^2> = 3^2:4.\n\
v has 1 x 10 = 10 images under G; <v> has 10 images under G.\n\
BASIS:\n\
NSB([x,y]) with above v.\n\
\n\
Possible matrix entries are in {-1,0,1}.\n\
\n\
Average number of nonzero entries for any element of the group:\n\
16 + 1/5  (16.2; 20% exactly).\n\
\n\
Entry  Av/Mat  %Av/Mat\n\
    0   64.8      80\n\
   1   16.2      20\n\
    1    8.1      10\n\
   -1    8.1      10\n\
";
result.symmetricforms:= [];
result.antisymmetricforms:= [];
result.hermitianforms:= [];
result.centralizeralgebra:= [];
result.generators:= List( [ [
1,0,0,0,0,0,0,0,0,
0,0,1,0,0,0,0,0,0,
0,1,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,
0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,1,0,
0,0,0,0,0,0,1,0,0,
0,0,0,0,0,1,0,0,0,
-1,-1,-1,-1,-1,-1,-1,-1,-1]
,[
0,1,0,0,0,0,0,0,0,
0,0,0,1,0,0,0,0,0,
0,0,0,0,1,0,0,0,0,
0,0,0,0,0,1,0,0,0,
0,0,0,0,0,0,1,0,0,
1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,1,0,
0,0,1,0,0,0,0,0,0]
], l -> List( [ 0 .. 8 ],
i -> l{ [ i*9+1 .. (i+1)*9 ] } ) );


l:= [
9,-1,-1,-1,-1,-1,-1,-1,-1,
-1,9,-1,-1,-1,-1,-1,-1,-1,
-1,-1,9,-1,-1,-1,-1,-1,-1,
-1,-1,-1,9,-1,-1,-1,-1,-1,
-1,-1,-1,-1,9,-1,-1,-1,-1,
-1,-1,-1,-1,-1,9,-1,-1,-1,
-1,-1,-1,-1,-1,-1,9,-1,-1,
-1,-1,-1,-1,-1,-1,-1,9,-1,
-1,-1,-1,-1,-1,-1,-1,-1,9];
Add( result.symmetricforms, List( [ 0 .. 8 ],
i -> l{ [ i*9+1 .. (i+1)*9 ] } ) );


Add( result.centralizeralgebra, IdentityMat(9) );
return result;
