/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Type;

public final class Function {
    private final CallContext callContext;
    final long functionAddress;
    final long contextAddress;

    public Function(long address2, Type returnType, Type ... paramTypes) {
        this(address2, returnType, paramTypes, CallingConvention.DEFAULT, true);
    }

    public Function(long address2, CallContext callContext) {
        this.functionAddress = address2;
        this.callContext = callContext;
        this.contextAddress = callContext.getAddress();
    }

    public Function(long address2, Type returnType, Type[] paramTypes, CallingConvention convention) {
        this(address2, returnType, paramTypes, convention, true);
    }

    public Function(long address2, Type returnType, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        this.functionAddress = address2;
        this.callContext = CallContext.getCallContext(returnType, paramTypes, convention, saveErrno);
        this.contextAddress = this.callContext.getAddress();
    }

    public Function(long address2, Type returnType, int fixedParamCount, Type[] paramTypes, CallingConvention convention, boolean saveErrno) {
        this.functionAddress = address2;
        this.callContext = CallContext.getCallContext(returnType, fixedParamCount, paramTypes, convention, saveErrno);
        this.contextAddress = this.callContext.getAddress();
    }

    public final int getParameterCount() {
        return this.callContext.getParameterCount();
    }

    public final int getRawParameterSize() {
        return this.callContext.getRawParameterSize();
    }

    public final CallContext getCallContext() {
        return this.callContext;
    }

    final long getContextAddress() {
        return this.contextAddress;
    }

    public final long getFunctionAddress() {
        return this.functionAddress;
    }

    public final Type getReturnType() {
        return this.callContext.getReturnType();
    }

    public final Type getParameterType(int index2) {
        return this.callContext.getParameterType(index2);
    }

    @Deprecated
    public final void dispose() {
    }
}

