/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import com.headius.invokebinder.Binder;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import org.jruby.RubySymbol;
import org.jruby.ir.targets.indy.Bootstrap;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.util.CodegenUtils;

public class FrameNameSite
extends MutableCallSite {
    private final String file;
    private final int line;
    private RubySymbol methodCached;
    public static final Handle FRAME_NAME_BOOTSTRAP = Bootstrap.getBootstrapHandle("frameNameBootstrap", FrameNameSite.class, CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE));

    public FrameNameSite(MethodType type2, String file2, int line) {
        super(type2);
        this.file = file2;
        this.line = line;
    }

    public static CallSite frameNameBootstrap(MethodHandles.Lookup lookup, String name2, MethodType methodType, String file2, int line) {
        FrameNameSite frameNameSite = new FrameNameSite(methodType, file2, line);
        frameNameSite.setTarget(Binder.from(methodType).prepend(frameNameSite, name2).invokeVirtualQuiet("frameNameFallback"));
        return frameNameSite;
    }

    public IRubyObject frameNameFallback(String name2, ThreadContext context, IRubyObject self2, String frameName) throws Throwable {
        String methodName = name2.split(":")[1];
        CacheEntry entry = self2.getMetaClass().searchWithCache(methodName);
        MethodHandle target2 = entry.method.isBuiltin() ? Binder.from(this.type()).permute(2).append(context.runtime.getSymbolTable()).prepend(this).invokeVirtualQuiet(methodName) : Binder.from(this.type()).permute(0, 1).invoke(SelfInvokeSite.bootstrap(MethodHandles.lookup(), name2, MethodType.methodType(IRubyObject.class, ThreadContext.class, IRubyObject.class), 0, 0, this.file, this.line).dynamicInvoker());
        this.setTarget(target2);
        return target2.invokeExact(context, self2, frameName);
    }

    public IRubyObject __callee__(String frameName, RubySymbol.SymbolTable symbolTable) {
        if (frameName.charAt(0) != '\u0000') {
            return this.getSimpleName(frameName, symbolTable);
        }
        return symbolTable.getCalleeSymbolFromCompound(frameName);
    }

    public IRubyObject __method__(String frameName, RubySymbol.SymbolTable symbolTable) {
        if (frameName.charAt(0) != '\u0000') {
            return this.getSimpleName(frameName, symbolTable);
        }
        return symbolTable.getMethodSymbolFromCompound(frameName);
    }

    private RubySymbol getSimpleName(String frameName, RubySymbol.SymbolTable symbolTable) {
        RubySymbol simpleName = this.methodCached;
        if (simpleName == null || !frameName.equals(simpleName.idString())) {
            this.methodCached = symbolTable.getSymbol(frameName, true);
            return this.methodCached;
        }
        return simpleName;
    }
}

