/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.FkSecondPass;
import org.hibernate.boot.model.internal.TableBinder;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;

class ToOneFkSecondPass
implements FkSecondPass {
    private final PersistentClass persistentClass;
    private final MetadataBuildingContext buildingContext;
    private final boolean unique;
    private final String path;
    private final String entityClassName;
    private final boolean annotatedEntity;
    private final ToOne value;
    private final AnnotatedJoinColumns columns;

    ToOneFkSecondPass(ToOne value, AnnotatedJoinColumns columns, boolean unique, boolean annotatedEntity, PersistentClass persistentClass, String path, MetadataBuildingContext buildingContext) {
        this.value = value;
        this.columns = columns;
        this.persistentClass = persistentClass;
        this.buildingContext = buildingContext;
        this.unique = unique;
        this.entityClassName = persistentClass.getClassName();
        this.path = this.entityClassName != null ? path.substring(this.entityClassName.length() + 1) : path;
        this.annotatedEntity = annotatedEntity;
    }

    @Override
    public SimpleValue getValue() {
        return this.value;
    }

    @Override
    public String getReferencedEntityName() {
        return this.value.getReferencedEntityName();
    }

    @Override
    public boolean isInPrimaryKey() {
        if (this.entityClassName == null) {
            return false;
        }
        PersistentClass persistentClass = this.buildingContext.getMetadataCollector().getEntityBinding(this.entityClassName);
        Property property = persistentClass.getIdentifierProperty();
        if (this.path == null) {
            return false;
        }
        if (property != null) {
            return this.path.startsWith(property.getName() + ".");
        }
        KeyValue keyValue = persistentClass.getIdentifier();
        if (keyValue instanceof Component) {
            Component component = (Component)keyValue;
            String localPath = this.path;
            if (this.path.startsWith("id.")) {
                localPath = this.path.substring(3);
            }
            for (Property idProperty : component.getProperties()) {
                if (!localPath.equals(idProperty.getName()) && !localPath.startsWith(idProperty.getName() + ".")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        ToOne toOne = this.value;
        if (toOne instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)toOne;
            String targetEntityName = manyToOne.getReferencedEntityName();
            PersistentClass targetEntity = persistentClasses.get(targetEntityName);
            if (targetEntity == null) {
                String problem = this.annotatedEntity ? " which does not belong to the same persistence unit" : " which is not an '@Entity' type";
                throw new AnnotationException("Association '" + StringHelper.qualify(this.entityClassName, this.path) + "' targets the type '" + targetEntityName + "'" + problem);
            }
            manyToOne.setPropertyName(this.path);
            String propertyRef = this.columns.getReferencedProperty();
            if (propertyRef != null) {
                this.handlePropertyRef(targetEntity, manyToOne, this.path, propertyRef, this.buildingContext);
            } else {
                BinderHelper.createSyntheticPropertyReference(this.columns, targetEntity, this.persistentClass, manyToOne, this.path, false, this.buildingContext);
            }
            TableBinder.bindForeignKey(targetEntity, this.persistentClass, this.columns, manyToOne, this.unique, this.buildingContext);
            if (!manyToOne.isIgnoreNotFound()) {
                manyToOne.createPropertyRefConstraints(persistentClasses);
            }
        } else if (this.value instanceof OneToOne) {
            this.value.createForeignKey();
        } else {
            throw new AssertionFailure("FkSecondPass for a wrong value type: " + this.value.getClass().getName());
        }
    }

    private void handlePropertyRef(PersistentClass targetEntity, ManyToOne manyToOne, String path, String referencedPropertyName, MetadataBuildingContext buildingContext) {
        manyToOne.setReferencedPropertyName(referencedPropertyName);
        manyToOne.setReferenceToPrimaryKey(false);
        String entityName = targetEntity.getEntityName();
        InFlightMetadataCollector metadataCollector = buildingContext.getMetadataCollector();
        metadataCollector.addUniquePropertyReference(entityName, referencedPropertyName);
        metadataCollector.addPropertyReferencedAssociation(entityName, path, referencedPropertyName);
    }
}

