/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.aq.AQAgent;

public interface AQMessageProperties {
    public static final int MESSAGE_NO_DELAY = 0;
    public static final int MESSAGE_NO_EXPIRATION = -1;
    public static final int INVALID_SHARD_ID = -1;

    public int getDequeueAttemptsCount();

    public void setCorrelation(String var1) throws SQLException;

    public String getCorrelation();

    public void setDelay(int var1) throws SQLException;

    public int getDelay();

    public Timestamp getEnqueueTime();

    public void setExceptionQueue(String var1) throws SQLException;

    public String getExceptionQueue();

    public void setExpiration(int var1) throws SQLException;

    public int getExpiration();

    public MessageState getState();

    public void setPriority(int var1) throws SQLException;

    public int getPriority();

    public void setShardNum(int var1) throws SQLException;

    public int getShardNum();

    public void setRecipientList(AQAgent[] var1) throws SQLException;

    public AQAgent[] getRecipientList();

    public void setSender(AQAgent var1) throws SQLException;

    public AQAgent getSender();

    public String getTransactionGroup();

    public byte[] getPreviousQueueMessageId();

    public DeliveryMode getDeliveryMode();

    public String toString();

    public static enum DeliveryMode {
        PERSISTENT(1),
        BUFFERED(2);

        private final int code;

        private DeliveryMode(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final DeliveryMode getDeliveryMode(int code) {
            if (code == BUFFERED.getCode()) {
                return BUFFERED;
            }
            return PERSISTENT;
        }
    }

    public static enum MessageState {
        WAITING(1),
        READY(0),
        PROCESSED(2),
        EXPIRED(3);

        private final int code;

        private MessageState(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final MessageState getMessageState(int code) {
            if (code == WAITING.getCode()) {
                return WAITING;
            }
            if (code == READY.getCode()) {
                return READY;
            }
            if (code == PROCESSED.getCode()) {
                return PROCESSED;
            }
            return EXPIRED;
        }
    }
}

