/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleShardingKey;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.util.Pair;

class RangeShardingKeys
implements ShardingKeys {
    private final OracleShardingKey keyLow;
    private final OracleShardingKey keyHigh;

    RangeShardingKeys(OracleShardingKey high, OracleShardingKey low) {
        this.keyHigh = high;
        this.keyLow = low;
    }

    @Override
    public boolean contains(OracleShardingKey key) {
        return key.compareTo((Object)this.keyLow) >= 0 && key.compareTo((Object)this.keyHigh) < 0;
    }

    public String toString() {
        return "[Low:" + this.keyLow + ", High:" + this.keyHigh + "]";
    }

    public int hashCode() {
        return 31 * this.keyLow.hashCode() + this.keyHigh.hashCode();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof RangeShardingKeys)) {
            return false;
        }
        RangeShardingKeys otherKeys = (RangeShardingKeys)otherObj;
        return this.keyLow.equals(otherKeys.keyLow) && this.keyHigh.equals(otherKeys.keyHigh);
    }

    @Override
    public int compareTo(ShardingKeys other) {
        RangeShardingKeys otherKeys = (RangeShardingKeys)other;
        int lowCompare = this.keyLow.compareTo((Object)otherKeys.keyLow);
        if (lowCompare != 0) {
            return lowCompare;
        }
        return this.keyHigh.compareTo((Object)otherKeys.keyHigh);
    }

    @Override
    public List<Pair<OracleShardingKey, OracleShardingKey>> getKeys() {
        ArrayList<Pair<OracleShardingKey, OracleShardingKey>> pairs = new ArrayList<Pair<OracleShardingKey, OracleShardingKey>>();
        pairs.add(new Pair<OracleShardingKey, OracleShardingKey>(this.keyLow, this.keyHigh));
        return pairs;
    }
}

