/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.keystore;

import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.opensearch.cli.Terminal;
import org.opensearch.cli.UserException;
import org.opensearch.common.settings.KeyStoreWrapper;
import org.opensearch.env.Environment;
import org.opensearch.tools.cli.keystore.BaseKeyStoreCommand;

class RemoveSettingKeyStoreCommand
extends BaseKeyStoreCommand {
    private final OptionSpec<String> arguments;

    RemoveSettingKeyStoreCommand() {
        super("Remove settings from the keystore", true);
        this.arguments = this.parser.nonOptions("setting names");
    }

    @Override
    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        List settings = this.arguments.values(options);
        if (settings.isEmpty()) {
            throw new UserException(64, "Must supply at least one setting to remove");
        }
        KeyStoreWrapper keyStore = this.getKeyStore();
        for (String setting : this.arguments.values(options)) {
            if (!keyStore.getSettingNames().contains(setting)) {
                throw new UserException(78, "Setting [" + setting + "] does not exist in the keystore.");
            }
            keyStore.remove(setting);
        }
        keyStore.save(env.configDir(), this.getKeyStorePassword().getChars());
    }
}

