"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFromSavedObject = getFromSavedObject;
var _lodash = require("lodash");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function getFromSavedObject(savedObject) {
  if ((0, _lodash.get)(savedObject, 'attributes.fields') === undefined) {
    return;
  }
  const fields = JSON.parse(savedObject.attributes.fields);
  return {
    id: savedObject.id,
    fields,
    title: savedObject.attributes.title
  };
}