/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.derivedsource;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.IOUtils;
import org.opensearch.common.Nullable;

public final class DerivedSourceReaders
implements Closeable {
    @Nullable
    private final KnnVectorsReader knnVectorsReader;
    @Nullable
    private final DocValuesProducer docValuesProducer;
    private final AtomicInteger ref = new AtomicInteger(1);

    public DerivedSourceReaders cloneWithMerge() {
        return this;
    }

    @Override
    public void close() throws IOException {
        this.decRef();
    }

    private void incRef() {
        int count;
        while ((count = this.ref.get()) > 0) {
            if (!this.ref.compareAndSet(count, count + 1)) continue;
            return;
        }
        throw new AlreadyClosedException("DerivedSourceReaders is already closed");
    }

    private void decRef() throws IOException {
        if (this.ref.decrementAndGet() == 0) {
            IOUtils.close((Closeable[])new Closeable[]{this.knnVectorsReader, this.docValuesProducer});
        }
    }

    @Generated
    public DerivedSourceReaders(KnnVectorsReader knnVectorsReader, DocValuesProducer docValuesProducer) {
        this.knnVectorsReader = knnVectorsReader;
        this.docValuesProducer = docValuesProducer;
    }

    @Generated
    public KnnVectorsReader getKnnVectorsReader() {
        return this.knnVectorsReader;
    }

    @Generated
    public DocValuesProducer getDocValuesProducer() {
        return this.docValuesProducer;
    }

    @Generated
    public AtomicInteger getRef() {
        return this.ref;
    }
}

